/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.cmdtools.OIFCFGUtil;
import oracle.cluster.cmdtools.USMDriverUtil;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.impl.verification.AvailableSpaceInfoImpl;
import oracle.cluster.impl.verification.SpaceResultSetImpl;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.InstallException;
import oracle.cluster.resources.PrCiMsgID;
import oracle.cluster.verification.DiskInfoResultSet;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.SpaceResultSet;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.constraints.XmlTaskFactory;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.LocalCSSException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.cluster.VoteDiskInfo;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.registry.RegistryKeyData;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageBundleList;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.GetSpaceCommand;
import oracle.ops.verification.framework.command.RunGenericCommand;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskMulticastCheck;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.ClusterNetworkInfo;
import oracle.ops.verification.framework.network.InterfaceInfo;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.param.CLSyntax;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CommandsUtil;
import oracle.ops.verification.framework.util.ConfigUtil;
import oracle.ops.verification.framework.util.EraserThread;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.HAHomeNotFoundException;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.InvalidOUIInventoryDataException;
import oracle.ops.verification.framework.util.InventoryFilePointerException;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.OIFCFGInfo;
import oracle.ops.verification.framework.util.OUIData;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VersionComparator;
import oracle.ops.verification.framework.util.sVerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class VerificationUtil
implements VerificationConstants {
    public static final String CVUQDISK_PACKAGE_NAME = "cvuqdisk";
    public static final String CVUQDISK_RPM_FILE_NAME = "cvuqdisk-1.0.9-1.rpm";
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static long KILO_BYTE = 1024L;
    private static long MEGA_BYTE = 0x100000L;
    private static long GIGA_BYTE = 0x40000000L;
    private static long TERA_BYTE = 0x10000000000L;
    private static String TRACE_CLUVFY_FNAME = "cvutrace.log";
    private static int CLUVFY = 1;
    private static String CV = "cv";
    private static String LOG = "log";
    private static boolean m_noReportException = false;
    private static boolean m_isLocalNodeOperationChecked = false;
    private static boolean m_isLocal = false;
    private static String m_localHostName = null;
    private static String[] m_nodeList = null;
    private static String[] m_nodeListFromOlsnodes = new String[0];
    private static boolean m_olsnodesExecuted = false;
    private static String[] m_nodeListFromInv = new String[0];
    private static boolean m_inventoryInspected = false;
    public static final String NODE_ALL = "CV_NODE_ALL";
    public static final String ASSUME_DISTID = "CV_ASSUME_DISTID";
    public static final String ASSUME_CL_VERSION = "CV_ASSUME_CL_VERSION";
    public static final String SUDO_LOCATION_PATH = "CV_SUDO_BINARY_LOCATION";
    public static final String PBRUN_LOCATION_PATH = "CV_PBRUN_BINARY_LOCATION";
    public static final String DEFAULT_BROWSER_LOCATION = "CV_DEFAULT_BROWSER_LOCATION";
    public static final String ORA_INST_INVPTR_PROPERTY = "oracle.installer.invPtrLoc";
    private static final String CTSS_CHECK_COMMAND = "crsctl check ctss";
    private static final String CTSS_RES_QUERY_COMMAND = "crsctl stat resource ora.ctssd -init";
    private static final String VDISK_DEFAULT_PERMISSIONS = "0640";
    private static final String ASM_PATH_CHARACTER = "+";
    private static final String CV_CRS_PREREQ_XML = "crsinst_prereq.xml";
    private static final String CV_DB_PREREQ_XML = "dbinst_prereq.xml";
    private static final String CV_HA_PREREQ_XML = "sihainst_prereq.xml";
    public static final String HA_HOME_REQ = "HA";
    public static final String CRS_HOME_REQ = "CRS";
    public static final String HA_OR_CRS_HOME_REQ = "BOTH";
    public static final String ORACLE_USER = "ORACLE_USER";
    public static final String ORA_CRS_HOME = "ORA_CRS_HOME";
    private static String m_cvuQDiskGrp = null;
    protected static String s_cvhome;
    protected static String s_destloc;
    protected static String s_traceloc;
    protected static String s_RDBMSVersion;
    protected static String s_currentGroup;
    protected static boolean m_isLocalNodeOper;
    protected static String s_HAHome;
    protected static Map<String, String> s_variableValueRepos;
    protected static Map<String, Boolean> s_conditionValueRepos;
    protected static Map<VerificationType, String> s_preReqXmlRepos;
    protected static String s_genericPreReqXmlFile;
    protected static String s_cvuLogFile;
    protected static Map<String, String> s_releaseVersionMap;
    protected static HashSet s_secVariable;
    private static HashMap<String, String> m_adminGroups;
    private static boolean m_getAdminGroups;
    private static boolean m_getRACGroups;
    private static boolean m_groupExceptionReported;
    private static String m_asmAdminGroup;
    private static String m_asmOperGroup;
    private static String m_asmDbaGroup;
    private static String m_osAsmGroup;
    private static String m_osOperGroup;
    private static String m_osDbaGroup;
    private static String m_osBackupDBAGroup;
    private static String m_osDgDBAGroup;
    private static String m_osKmDBAGroup;
    private static Hashtable<String, Boolean> asmDiscoveryStringHT;

    public static void setNoReportException(boolean x) {
        m_noReportException = x;
    }

    public static synchronized void setNodelist(String[] nodeList) {
        m_nodeList = nodeList;
    }

    public static synchronized String[] getNodelist() throws NodelistNotFoundException {
        int p;
        String[] autoNodes;
        String[] rimNodes;
        String[] hubNodes;
        if (m_nodeList != null) {
            return m_nodeList;
        }
        ArrayList<String> nodelist = new ArrayList<String>();
        String[] classicNodes = VerificationUtil.getNodelist(Argument.ARG_NODELIST);
        if (classicNodes != null) {
            nodelist.addAll(Arrays.asList(classicNodes));
        }
        if ((hubNodes = VerificationUtil.getNodelist(Argument.ARG_HUBLIST)) != null) {
            nodelist.addAll(Arrays.asList(hubNodes));
        }
        if ((rimNodes = VerificationUtil.getNodelist(Argument.ARG_RIMLIST)) != null) {
            nodelist.addAll(Arrays.asList(rimNodes));
        }
        if ((autoNodes = VerificationUtil.getNodelist(Argument.ARG_AUTOLIST)) != null) {
            nodelist.addAll(Arrays.asList(autoNodes));
        }
        if (nodelist.size() > 0) {
            Trace.out((String)"====VerificationUtil gets the nodelist from ParamManager as: ");
            for (int i = 0; i < nodelist.size(); ++i) {
                Trace.out((String)("  ==Node " + i + " is:" + (String)nodelist.get(i)));
            }
        } else {
            Trace.out((String)"Nodelist was null. Trying to get the localhost");
            nodelist.add(VerificationUtil.getNodeName(VerificationUtil.getLocalHostName()));
        }
        for (p = 0; p < nodelist.size(); ++p) {
            Trace.out((String)("==== Nodelist before processing: nodelist[" + p + "]:" + (String)nodelist.get(p)));
        }
        if (nodelist != null) {
            for (int k = 0; k < nodelist.size(); ++k) {
                nodelist.set(k, VerificationUtil.getShortHostname((String)nodelist.get(k)));
            }
        }
        for (p = 0; p < nodelist.size(); ++p) {
            Trace.out((String)("==== Nodelist after: nodelist[" + p + "]:" + (String)nodelist.get(p)));
        }
        VerificationUtil.setLocalNodeFirst(nodelist);
        VerificationLogData.logInfo("nodeList: " + VerificationUtil.strCollection2String(nodelist));
        m_nodeList = nodelist.toArray(new String[0]);
        return m_nodeList;
    }

    private static String[] getNodelist(int argument) throws NodelistNotFoundException {
        String[] nodelist;
        ParamManager pm = null;
        try {
            pm = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            throw new NodelistNotFoundException(e.getMessage());
        }
        Argument nodelistArg = pm.getArgument(argument);
        if (nodelistArg == null) {
            nodelist = null;
        } else if (argument == Argument.ARG_NODELIST && nodelistArg.isAllSpecified()) {
            nodelist = VerificationUtil.getStaticNodelist();
            Trace.out((String)("nodelist obtained from getStaticNodelist(): " + VerificationUtil.strArr2List(nodelist)));
        } else {
            nodelist = pm.getMultiPartArgVal(argument);
        }
        return nodelist;
    }

    public static String getShortHostname(String longHostname) {
        if (longHostname == null) {
            return null;
        }
        int dotIdx = longHostname.indexOf(".");
        String hostName = dotIdx != -1 ? longHostname.substring(0, dotIdx) : longHostname;
        return hostName;
    }

    public static String getLocalNodename() throws NodelistNotFoundException {
        String localNodeName = null;
        if (VerificationUtil.isHAConfigured()) {
            try {
                localNodeName = VerificationUtil.getNodeName(VerificationUtil.getLocalHost());
            }
            catch (UnknownHostException e) {
                Trace.out((String)("UnknownHostException Thrown with message : " + e.getMessage()));
                VerificationUtil.reportException(e);
            }
        } else {
            String crsHome = VerificationUtil.getCRSHome();
            try {
                ClusterInfo cluInfo = new ClusterInfo(crsHome);
                localNodeName = cluInfo.getLocalNodeName();
            }
            catch (NoSuchCRSHomeException nche) {
                Trace.out((String)("====  ALERT!! CRS_HOME is bad or missing. NoSuchCRSHomeException: '" + nche.getMessage() + "'"));
                throw new NodelistNotFoundException(s_msgBundle.getMessage("9001", false, new Object[]{new String(crsHome)}));
            }
            catch (NoSuchExecutableException nsee) {
                Trace.out((String)("==== ALERT!! olsnodes executable is missing. NoSuchExecutableException: '" + nsee.getMessage() + "'"));
                throw new NodelistNotFoundException(s_msgBundle.getMessage("9003", false));
            }
            catch (ClusterInfoException cie) {
                Trace.out((String)("==== ALERT!! CRS home available, but olsnodes  does not work. Exception: '" + cie.getMessage() + "'"));
                throw new NodelistNotFoundException(s_msgBundle.getMessage("9004", false));
            }
        }
        VerificationLogData.logInfo("localNodeName: " + localNodeName);
        return localNodeName;
    }

    public static String getLocalHostName() {
        return m_localHostName;
    }

    public static void setLocalHostName(String localHostName) {
        m_localHostName = localHostName;
    }

    public static String getLocalHost() throws UnknownHostException {
        String longHostName = InetAddress.getLocalHost().getHostName();
        int dotIdx = longHostName.indexOf(".");
        String hostName = dotIdx != -1 ? longHostName.substring(0, dotIdx) : longHostName;
        Trace.out((String)("Hostname retrieved: " + longHostName + ", returned: " + hostName));
        VerificationLogData.logInfo("LongHostName: " + longHostName + ", HostName: " + hostName);
        return hostName;
    }

    public static String getNodeName(String hostName) {
        if (hostName != null) {
            int dotIdx = hostName.indexOf(".");
            hostName = dotIdx != -1 ? hostName.substring(0, dotIdx) : hostName;
            return hostName.toLowerCase();
        }
        return null;
    }

    public static String[] getStaticNodelist() throws NodelistNotFoundException {
        if (VerificationUtil.isHAConfigured()) {
            Trace.out((String)"Returning local node since HA is configured");
            return new String[]{m_localHostName};
        }
        Trace.out((String)"Attempt to fetch nodelist using olsnodes");
        String[] olsnodesList = VerificationUtil.getNodelistFromOlsnodesWithException();
        if (olsnodesList != null && olsnodesList.length != 0) {
            return olsnodesList;
        }
        Trace.out((String)"Nodes not found using olsnodes; Looking for CV_NODE_ALL setting");
        String ndlist = VerificationUtil.getConfiguredValue(NODE_ALL, true);
        if (ndlist == null || ndlist.trim().length() <= 0) {
            throw new NodelistNotFoundException(s_msgBundle.getMessage("9005", false, new Object[]{new String(NODE_ALL)}));
        }
        String[] nodelist = VerificationUtil.getTokensAsArray(ndlist, ",");
        ArrayList<String> nodeListLocal = new ArrayList<String>();
        nodeListLocal.addAll(Arrays.asList(nodelist));
        VerificationUtil.setLocalNodeFirst(nodeListLocal);
        nodelist = nodeListLocal.toArray(new String[0]);
        Trace.out((String)"==== Nodelist retrieved from CV_NODE_ALL variable.");
        Trace.out((String)("==== Nodelist: " + ndlist));
        VerificationLogData.logInfo("staticNodelist: " + VerificationUtil.strArr2List(nodelist));
        return nodelist;
    }

    public static String[] getNodelistFromOlsnodes() {
        try {
            VerificationUtil.getNodelistFromOlsnodesWithException();
        }
        catch (NodelistNotFoundException nlnfe) {
            Trace.out((String)("Node list could not be found from olsnodes:" + nlnfe.getMessage()));
        }
        return m_nodeListFromOlsnodes;
    }

    public static synchronized String[] getNodelistFromOlsnodesWithException() throws NodelistNotFoundException {
        if (m_olsnodesExecuted) {
            return m_nodeListFromOlsnodes;
        }
        m_olsnodesExecuted = true;
        String crsHome = VerificationUtil.getCRSHome();
        Trace.out((String)("==== CRS home: " + crsHome));
        if (crsHome != null && crsHome.trim().length() > 0) {
            try {
                ClusterInfo cluInfo = new ClusterInfo(crsHome);
                m_nodeListFromOlsnodes = cluInfo.getNodeNames();
                Trace.out((String)"==== Nodelist retrieved from Oracle Clusterware");
                Trace.out((String)("==== m_nodeListFromOlsnodes: " + VerificationUtil.strArr2List(m_nodeListFromOlsnodes)));
                VerificationLogData.logInfo("m_nodeListFromOlsnodes: " + VerificationUtil.strArr2List(m_nodeListFromOlsnodes));
                return m_nodeListFromOlsnodes;
            }
            catch (NoSuchCRSHomeException nche) {
                Trace.out((String)("====  ALERT!! CRS_HOME is bad or missing. NoSuchCRSHomeException: '" + nche.getMessage() + "'"));
                throw new NodelistNotFoundException(s_msgBundle.getMessage("9001", false, new Object[]{new String(crsHome)}));
            }
            catch (NoSuchExecutableException nsee) {
                Trace.out((String)("==== ALERT!! olsnodes executable is missing. NoSuchExecutableException: '" + nsee.getMessage() + "'"));
                throw new NodelistNotFoundException(s_msgBundle.getMessage("9003", false));
            }
            catch (ClusterInfoException cie) {
                Trace.out((String)("==== ALERT!! CRS home available, but olsnodes  does not work. Exception: '" + cie.getMessage() + "'"));
                throw new NodelistNotFoundException(s_msgBundle.getMessage("9004", false));
            }
        }
        Trace.out((String)("returning with m_nodeListFromOlsnodes as: '" + VerificationUtil.strArr2List(m_nodeListFromOlsnodes) + "'"));
        return m_nodeListFromOlsnodes;
    }

    public static String[] getNodelistFromInv() {
        try {
            VerificationUtil.getNodelistFromInvWithException();
        }
        catch (InvalidOUIInventoryDataException inve) {
            Trace.out((String)("Node list could not be found from inventory:" + inve.getMessage()));
        }
        return m_nodeListFromInv;
    }

    public static synchronized String[] getNodelistFromInvWithException() throws InvalidOUIInventoryDataException {
        if (m_inventoryInspected) {
            return m_nodeListFromInv;
        }
        m_inventoryInspected = true;
        String inventoryFile = null;
        OUIData ouid = null;
        inventoryFile = VerificationUtil.getInventoryFileLocation();
        ouid = OUIData.getInstance(inventoryFile);
        if (ouid.isCRSInstalled()) {
            m_nodeListFromInv = ouid.getCRSNodes();
        }
        Trace.out((String)("returning with m_nodeListFromInv as: '" + VerificationUtil.strArr2List(m_nodeListFromInv) + "'"));
        return m_nodeListFromInv;
    }

    public static String[] getVendorStaticNodelist() throws NodelistNotFoundException {
        String[] nodelist = null;
        String lsnodesHome = null;
        ParamManager pm = null;
        boolean isAPIMode = false;
        try {
            pm = ParamManager.getInstance();
            if (pm.getMode() == ParamManager.OperationMode.MODE_API) {
                isAPIMode = true;
            }
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((String)("UNINITIALIZEDPARAMMGREXCEPTION: " + e.getMessage()));
        }
        try {
            lsnodesHome = CVUAutoUpdateManager.getLSNodesHome(isAPIMode);
            ClusterInfo pre10iCluInfo = new ClusterInfo(lsnodesHome, Version.get92Version());
            nodelist = pre10iCluInfo.getNodeNames();
            Trace.out((String)"==== Nodelist retrieved from vendor clusterware");
            Trace.out((String)("==== Nodelist: " + VerificationUtil.strArr2List(nodelist)));
            VerificationLogData.logInfo("vendorStaticNodelist: " + VerificationUtil.strArr2List(nodelist));
            return nodelist;
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)("====  ALERT!! CV_HOME is bad or missing. NoSuchCRSHomeException: '" + nche.getMessage() + "'"));
            throw new NodelistNotFoundException(s_msgBundle.getMessage("9000", false, new Object[]{new String(VerificationUtil.getCVHome())}));
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)("==== ALERT!! lsnodes executable is missing. NoSuchExecutableException: '" + nsee.getMessage() + "'"));
            throw new NodelistNotFoundException(s_msgBundle.getMessage("9002", false));
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)("==== Unable to retrieve nodelist from vendor clusterware. Exception: '" + cie.getMessage() + "'"));
            VerificationLogData.logInfo("vendorStaticNodelist: " + VerificationUtil.strArr2List(nodelist));
            return nodelist;
        }
    }

    public static Vector listRecursiveFiles(Vector listFilesDirs) {
        Vector fileDirVect = (Vector)listFilesDirs.clone();
        String cvhome = VerificationUtil.getCVHome();
        if (fileDirVect == null || cvhome == null) {
            return null;
        }
        Trace.out((String)("InputList=" + VerificationUtil.strVect2List(listFilesDirs)));
        File f = null;
        int i = 0;
        while (i < fileDirVect.size()) {
            String elementName = (String)fileDirVect.elementAt(i);
            Trace.out((int)1, (String)("Working with element:" + elementName));
            if (elementName.startsWith(".")) {
                fileDirVect.removeElementAt(i);
                continue;
            }
            f = new File(cvhome + FILE_SEPARATOR + elementName);
            if (!f.isAbsolute()) {
                Trace.out((int)1, (String)("cvhome '" + cvhome + "'  is not an absolute path"));
                return null;
            }
            if (!f.exists()) {
                fileDirVect.removeElementAt(i);
                continue;
            }
            if (f.isFile()) {
                Trace.out((int)1, (String)" is a File.");
                ++i;
                continue;
            }
            if (f.isDirectory()) {
                Trace.out((int)1, (String)" is a Directory.");
                String[] list = f.list();
                for (int j = 0; list != null && j < list.length; ++j) {
                    Trace.out((int)1, (String)("Working with directory element: " + list[j]));
                    if (!list[j].startsWith(".")) {
                        String path = elementName + FILE_SEPARATOR + list[j];
                        fileDirVect.add(path);
                        Trace.out((int)1, (String)("Adding: '" + path + "'"));
                        continue;
                    }
                    Trace.out((int)1, (String)("Ignoring: '" + elementName + FILE_SEPARATOR + list[j] + "'"));
                }
                fileDirVect.removeElementAt(i);
                continue;
            }
            ++i;
        }
        Trace.out((String)("OutputList=" + VerificationUtil.strVect2List(fileDirVect)));
        return fileDirVect;
    }

    public static void updateResultMap(Hashtable<Object, Vector<Object>> t, Object key, Object vectElem) {
        if (t.containsKey(key)) {
            if (!t.get(key).contains(vectElem)) {
                t.get(key).add(vectElem);
            }
        } else {
            Vector<Object> newVal = new Vector<Object>();
            newVal.add(vectElem);
            t.put(key, newVal);
        }
    }

    public static String strArr2List(String[] strArr) {
        if (strArr == null) {
            return "";
        }
        return VerificationUtil.strCollection2String(Arrays.asList(strArr));
    }

    public static String strArr2List(String[] strArr, String delimiter) {
        if (strArr == null) {
            return "";
        }
        return VerificationUtil.strCollection2String(Arrays.asList(strArr), delimiter);
    }

    public static String objArr2String(Object[] objArr) {
        return VerificationUtil.objArr2String(objArr, ",");
    }

    public static String objArr2String(Object[] objArr, String delim) {
        if (objArr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < objArr.length; ++i) {
            sb.append(objArr[i].toString());
            if (i >= objArr.length - 1) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String strArr2String(String[] strarr) {
        if (strarr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strarr.length; ++i) {
            sb.append(strarr[i]);
        }
        return sb.toString();
    }

    public static String strArr2String(String[] strarr, String delim) {
        if (strarr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strarr.length; ++i) {
            sb.append(strarr[i]);
            if (i >= strarr.length - 1) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String[] string2strArr(String str) {
        return VerificationUtil.string2strArr(str, ",");
    }

    public static String[] string2strArr(String str, String delim) {
        Vector<String> strVect = new Vector<String>();
        int dlmPos = 0;
        int index = 0;
        while (index < str.length()) {
            dlmPos = str.indexOf(delim, index);
            if (dlmPos == -1) {
                strVect.add(str.substring(index));
                break;
            }
            if (dlmPos == index) {
                ++index;
                continue;
            }
            strVect.add(str.substring(index, dlmPos));
            index = dlmPos + 1;
        }
        return strVect.toArray(new String[strVect.size()]);
    }

    public static String strVect2List(Vector<String> v) {
        return VerificationUtil.strCollection2String(v);
    }

    public static String strList2List(List<String> l) {
        return VerificationUtil.strCollection2String(l);
    }

    public static String strList2List(List<String> l, String delimiter) {
        return VerificationUtil.strCollection2String(l, delimiter);
    }

    public static <T> String strCollection2String(Collection<T> l) {
        return VerificationUtil.strCollection2String(l, ",");
    }

    public static <T> String strCollection2String(Collection<T> l, String delim) {
        StringBuffer strBuf = new StringBuffer("");
        if (l != null) {
            boolean first = true;
            for (T item : l) {
                if (first) {
                    first = false;
                } else {
                    strBuf.append(delim);
                }
                strBuf.append(String.valueOf(item));
            }
        }
        return strBuf.toString();
    }

    public static Vector getTokens(String str, String dlm) {
        int dlmPos = 0;
        Vector<String> tokenList = new Vector<String>();
        int index = 0;
        while (index < str.length()) {
            dlmPos = str.indexOf(dlm, index);
            if (dlmPos == -1) {
                tokenList.add(str.substring(index));
                return tokenList;
            }
            if (dlmPos == index) {
                index += dlm.length();
                continue;
            }
            tokenList.add(str.substring(index, dlmPos));
            index = dlmPos + dlm.length();
        }
        return tokenList;
    }

    public static String[] getTokensAsArray(String str, String dlm) {
        String[] tokarr;
        Vector vector = VerificationUtil.getTokens(str, dlm);
        if (vector != null) {
            tokarr = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                tokarr[i] = (String)vector.elementAt(i);
            }
        } else {
            tokarr = new String[]{};
        }
        return tokarr;
    }

    public static String getDefaultOracleUser() {
        String curUser = System.getProperty("user.name");
        VerificationLogData.logInfo("DefaultOracleUser: " + curUser);
        Trace.out((String)("==== Oracle user(current user) is " + curUser));
        return curUser;
    }

    public static String getDefaultCRSUser() {
        String curUser = System.getProperty("user.name");
        Trace.out((String)("==== Oracle user(current user) is " + curUser));
        VerificationLogData.logInfo("DefaultCRSUser: " + curUser);
        return curUser;
    }

    public static String getCRSHome(String node, Result result) {
        String crsHome = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        try {
            crsHome = nativeSys.getCRSHome(node, new Version());
        }
        catch (NativeException e) {
            Trace.out((String)("IGNORED: " + e.getMessage()));
            Trace.out((String)"Will attempt a fallback.");
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(e.getMessage()));
        }
        if (crsHome != null) {
            result.setStatus(1);
            VerificationLogData.logInfo("CRSHome: " + crsHome);
            return crsHome;
        }
        crsHome = VerificationUtil.getCRSHomeFromInitCSSD(node, result);
        if (crsHome != null) {
            result.setStatus(1);
            VerificationLogData.logInfo("CRSHome: " + crsHome);
            return crsHome;
        }
        String crsHomeFromInv = VerificationUtil.getCRSHomeFromInventory(result);
        crsHome = VerificationUtil.getCRSHomeFromOCRDump(crsHomeFromInv, node, result);
        if (crsHome != null) {
            result.setStatus(1);
            VerificationLogData.logInfo("CRSHome: " + crsHome);
            return crsHome;
        }
        crsHome = crsHomeFromInv;
        if (crsHome != null) {
            result.setStatus(1);
            VerificationLogData.logInfo("CRSHome: " + crsHome);
            return crsHome;
        }
        ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("5301", true));
        result.addErrorDescription(errDesc);
        result.setStatus(3);
        VerificationLogData.logError("CRSHome: NULL!!!");
        return null;
    }

    public static String getCRSUser(String node, Result result, boolean isSIHA) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            result.setStatus(2);
            return null;
        }
        ErrorDescription errDesc = null;
        String version = null;
        String errorMsg = null;
        String home = null;
        String userNameStr = null;
        try {
            if (isSIHA) {
                if (VerificationUtil.isHAConfigured()) {
                    home = VerificationUtil.getHAHomeWithException();
                    version = VerificationUtil.getSIHAReleaseVersionWithException();
                } else {
                    home = ClusterInfo.getLocalCSSHome((Version)new Version());
                    version = VerificationUtil.getCRSActiveVersionWithException();
                }
            } else {
                home = VerificationUtil.getCRSHome();
                version = VerificationUtil.getCRSActiveVersionWithException();
            }
        }
        catch (NoSuchCRSHomeException nscrse) {
            errorMsg = nscrse.getMessage();
        }
        catch (NoSuchExecutableException nsee) {
            errorMsg = nsee.getMessage();
        }
        catch (ClusterInfoException cie) {
            errorMsg = cie.getMessage();
        }
        catch (ConfigurationException cfge) {
            errorMsg = cfge.getMessage();
        }
        catch (HAHomeNotFoundException hae) {
            errorMsg = hae.getMessage();
        }
        catch (LocalCSSException lce) {
            errorMsg = lce.getMessage();
        }
        if (version == null && home != null) {
            Trace.out((String)"Retreival of Active version failed, now taking fallback approach");
            version = VerificationUtil.getCRSReleaseVersionUsingSRVCTL(home, m_localHostName, result);
        }
        if (VerificationUtil.isStringGood(version)) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Active CRS Version is: " + version));
            }
            String crsUserName = null;
            if (!VerificationUtil.isVersionPre(version, "11.2")) {
                return VerificationUtil.getCRSHomeUser(node, result, isSIHA);
            }
            String cssdFileLocation = sVerificationUtil.getCSSDFileLoc();
            userNameStr = VerificationUtil.grepCRSUserFromCSSD(node, cssdFileLocation);
            if (!VerificationUtil.isStringGood(userNameStr)) {
                cssdFileLocation = home + FILE_SEPARATOR + "css" + FILE_SEPARATOR + "admin" + FILE_SEPARATOR + new File(cssdFileLocation).getName();
                Trace.out((String)("Trying to get the CRS user from init.cssd SBS at location path " + cssdFileLocation));
                userNameStr = VerificationUtil.grepCRSUserFromCSSD(node, cssdFileLocation);
            }
            if (!VerificationUtil.isStringGood(userNameStr)) {
                Trace.out((String)"Retrieving the CRS User using OCR DUMP");
                userNameStr = VerificationUtil.getCrsUserFromOCRDump(home, result);
                if (VerificationUtil.isStringGood(userNameStr) && result.getStatus() == 1) {
                    Trace.out((int)5, (String)("OCR returned the CRS user name as : " + userNameStr));
                    userNameStr = userNameStr.trim();
                } else {
                    Trace.out((int)5, (String)"Failed to retrieve the CRS user name from OCR using OCR dump approach");
                }
            }
            if (VerificationUtil.isStringGood(userNameStr)) {
                if (userNameStr.contains("=")) {
                    int equalIndex = userNameStr.indexOf("=");
                    crsUserName = userNameStr.length() > equalIndex ? userNameStr.substring(equalIndex + 1) : null;
                } else {
                    crsUserName = userNameStr;
                }
            }
            if (VerificationUtil.isStringGood(crsUserName)) {
                Trace.out((int)5, (String)("The CRS User  name retrieved is :" + crsUserName));
                result.setStatus(1);
                VerificationLogData.logInfo("CRSUserName: " + crsUserName);
                return crsUserName;
            }
            Trace.out((String)"Failed to retrieve the crs user name ");
            errDesc = new ErrorDescription(s_msgBundle.getMessage("9556", true));
            result.addErrorDescription(errDesc);
            result.setStatus(3);
            return null;
        }
        errorMsg = VerificationUtil.isStringGood(errorMsg) ? s_msgBundle.getMessage("5300", true) + LSEP + errorMsg : s_msgBundle.getMessage("5300", true);
        errDesc = new ErrorDescription(errorMsg);
        result.addErrorDescription(errDesc);
        result.setStatus(2);
        return null;
    }

    private static String grepCRSUserFromCSSD(String node, String cssdFileLocation) {
        CommandsUtil cmdUtil = new CommandsUtil();
        GlobalExecution globalExec = new GlobalExecution();
        boolean rslt = false;
        String userNameStr = null;
        Trace.out((String)("Trying Grep approach on init.cssd at path " + cssdFileLocation + " to get the crs user"));
        String command = cmdUtil.getGrep() + " " + ORACLE_USER + "= " + cssdFileLocation;
        ResultSet usrInfoRsltSet = new ResultSet();
        rslt = globalExec.runExe(new String[]{node}, command, usrInfoRsltSet, false);
        Result usrResult = (Result)usrInfoRsltSet.getResultTable().get(node);
        if (rslt && usrResult != null && usrResult.getStatus() == 1) {
            Vector resultInfoset = usrResult.getResultInfoSet();
            String exectaskOutput = null;
            if (resultInfoset.size() > 1 && (exectaskOutput = (String)resultInfoset.elementAt(1)) != null && VerificationUtil.fetchVerificationResult(exectaskOutput).equals("0") && VerificationUtil.isStringGood(userNameStr = VerificationUtil.fetchVerificationValue(exectaskOutput))) {
                userNameStr = userNameStr.trim();
            }
        } else {
            Trace.out((String)("Failed to grep approach for crs user from init.cssd at path " + cssdFileLocation));
        }
        Trace.out((String)("Retrieved the CRS user name string from init.cssd as " + userNameStr));
        return userNameStr;
    }

    public static String getCRSUser(Result result, boolean isSIHA) {
        String localNode = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        ErrorDescription errDesc = null;
        if (!nativeSys.isUnixSystem()) {
            result.setStatus(2);
            return null;
        }
        if (isSIHA) {
            try {
                localNode = VerificationUtil.getNodeName(VerificationUtil.getLocalHost());
            }
            catch (UnknownHostException e) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"UnknownHostException caught");
                }
                errDesc = new ErrorDescription(s_msgBundle.getMessage("0002", true) + LSEP + e.getMessage());
                result.addErrorDescription(errDesc);
                result.setStatus(2);
                VerificationUtil.reportException(e);
                return null;
            }
            if (localNode == null) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"VerificationUtil::getCRSUser Failed to retrieve Local Node Name.");
                }
                errDesc = new ErrorDescription(s_msgBundle.getMessage("0002", true));
                result.addErrorDescription(errDesc);
                result.setStatus(2);
                return null;
            }
        } else {
            try {
                localNode = VerificationUtil.getLocalNodename();
            }
            catch (NodelistNotFoundException nlnfe) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"NodelistNotFoundException caught");
                }
                errDesc = new ErrorDescription(s_msgBundle.getMessage("0001", true) + LSEP + nlnfe.getMessage());
                result.addErrorDescription(errDesc);
                result.setStatus(2);
                VerificationUtil.reportException(nlnfe);
                return null;
            }
        }
        return VerificationUtil.getCRSUser(localNode, result, isSIHA);
    }

    public static String getCRSHomeUser(String node, Result result, boolean isSIHA) {
        Hashtable nodeFileList;
        FileInfo nodeFileInfo;
        String oracleBinaryName = "oracle";
        String home = null;
        ErrorDescription errDesc = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            result.setStatus(2);
            return null;
        }
        if (node == null) {
            errDesc = new ErrorDescription("7514", s_msgBundle);
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        home = isSIHA ? VerificationUtil.getHAHome() : VerificationUtil.getCRSHome(node, result);
        if (home == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("VerificationUtil::getCRSHomeUser(node) retreived Home as <NULL> for node : " + node));
            }
            return home;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("VerificationUtil::getCRSHomeUser(node) retreived Home as:" + home + " for node : " + node));
        }
        String oracleBinary = home + File.separator + "bin" + File.separator + nativeSys.getExeName(oracleBinaryName);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("VerificationUtil::getCRSHomeUser(node) get file info of File:" + oracleBinary + " from node : " + node));
        }
        ResultSet fileInfoRS = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        List<String> fileList = Arrays.asList(oracleBinary);
        boolean fileInfoResult = globalExec.getFileInfo(new String[]{node}, fileList, fileInfoRS);
        if (!fileInfoResult) {
            errDesc = new ErrorDescription(s_msgBundle.getMessage("5323", true, (Object[])new String[]{oracleBinary}), s_msgBundle, "5323");
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        Result fiResult = (Result)fileInfoRS.getResultTable().get(node);
        if (fiResult != null && fiResult.getStatus() == 1 && !(nodeFileInfo = (FileInfo)(nodeFileList = (Hashtable)fiResult.getResultInfoSet().elementAt(0)).get(oracleBinary)).getStatus().equals("1")) {
            result.setStatus(1);
            return nodeFileInfo.getFileOwner();
        }
        errDesc = new ErrorDescription(s_msgBundle.getMessage("5322", true, (Object[])new String[]{home}), s_msgBundle, "5322");
        result.addErrorDescription(errDesc);
        result.setStatus(2);
        return null;
    }

    public static String getOracleUser(String home, String node, Result result) {
        Hashtable nodeFileList;
        FileInfo nodeFileInfo;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        ErrorDescription errDesc = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            result.setStatus(2);
            return null;
        }
        if (node == null) {
            errDesc = new ErrorDescription("7514", s_msgBundle);
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        String oracleBinary = home + File.separator + "bin" + File.separator + nativeSys.getExeName("oracle");
        GlobalExecution globalExec = new GlobalExecution();
        List<String> fileList = Arrays.asList(oracleBinary);
        ResultSet resultSet = new ResultSet();
        boolean fileInfoResult = globalExec.getFileInfo(new String[]{node}, fileList, resultSet);
        Trace.out((String)"After calling globalExec.getFileInfo() ... ");
        if (!fileInfoResult) {
            result.setStatus(2);
            return null;
        }
        Result nodeResult = (Result)resultSet.getResultTable().get(node);
        if (nodeResult != null && nodeResult.getStatus() == 1 && !(nodeFileInfo = (FileInfo)(nodeFileList = (Hashtable)nodeResult.getResultInfoSet().elementAt(0)).get(oracleBinary)).getStatus().equals("1")) {
            result.setStatus(1);
            VerificationLogData.logInfo("OracleUser: " + nodeFileInfo.getFileOwner());
            return nodeFileInfo.getFileOwner();
        }
        errDesc = new ErrorDescription(s_gMsgBundle.getMessage("1186", true, (Object[])new String[]{home}), s_msgBundle, "5322");
        result.addErrorDescription(errDesc);
        result.setStatus(2);
        return null;
    }

    public static StringBuffer getKeyValueFromOCRDump(String crsHome, String ocrKey, Result result) {
        String command = null;
        ErrorDescription errDesc = null;
        String errorMsg = null;
        StringBuffer value = new StringBuffer();
        String localNode = null;
        try {
            localNode = VerificationUtil.getLocalNodename();
        }
        catch (NodelistNotFoundException nlnfe) {
            Trace.out((String)("Caught NodelistNotFoundException : Failed to get the local node name with erro " + nlnfe.getMessage()));
            errDesc = new ErrorDescription(s_msgBundle.getMessage("0001", true) + LSEP + nlnfe.getMessage());
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return value;
        }
        ResultSet homeInfoRsltSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        boolean rslt = false;
        command = crsHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "ocrdump -stdout -noheader -keyname " + ocrKey;
        Trace.out((int)5, (String)("Executing command=>" + command));
        rslt = globalExec.runExe(new String[]{localNode}, command, homeInfoRsltSet, false);
        Result homeResult = (Result)homeInfoRsltSet.getResultTable().get(localNode);
        if (rslt && homeResult != null && homeResult.getStatus() == 1) {
            Vector resultInfoset = homeResult.getResultInfoSet();
            Object cvVal = null;
            String[] exectaskOutput = null;
            if (resultInfoset.size() > 0) {
                exectaskOutput = (String[])resultInfoset.elementAt(0);
                boolean found = false;
                for (String line : exectaskOutput) {
                    if ((line = line.trim()).equals("[" + ocrKey + "]")) {
                        found = true;
                    }
                    if (!found) continue;
                    if (!line.equals("[" + ocrKey + "]") && line.startsWith("[" + ocrKey)) break;
                    value.append(line + LINE_SEPARATOR);
                }
            }
            if (value.length() > 0) {
                Trace.out((int)5, (String)("Successfully Retrieved value for key " + ocrKey + " the Value is :" + value.toString()));
                result.setStatus(1);
            } else {
                result.setStatus(3);
                errorMsg = s_gMsgBundle.getMessage("0551", true, (Object[])new String[]{ocrKey});
                result.addErrorDescription(new ErrorDescription(errorMsg));
            }
        } else {
            result.setStatus(2);
            errorMsg = s_gMsgBundle.getMessage("0550", true, (Object[])new String[]{ocrKey});
            result.addErrorDescription(new ErrorDescription(errorMsg));
            Trace.out((String)("Error in executing ocrdump command:" + command));
        }
        return value;
    }

    public static String getCrsUserFromOCRDump(String crsHome, Result result) {
        String key = "DATABASE.DATABASES";
        String usrName = null;
        StringBuffer ocrKeyValue = VerificationUtil.getKeyValueFromOCRDump(crsHome, key, result);
        if (ocrKeyValue != null && ocrKeyValue.length() > 0 && result.getStatus() == 1) {
            String[] lineByLine;
            for (String line : lineByLine = VerificationUtil.string2strArr(ocrKeyValue.toString(), LINE_SEPARATOR)) {
                Pattern userNamePattern = Pattern.compile("(.*)USER_NAME([^:]*):(\\s*)([^,]*)(.*)");
                Matcher m = userNamePattern.matcher(line);
                if (!m.matches()) continue;
                usrName = m.group(4);
                break;
            }
        }
        if (!VerificationUtil.isStringGood(usrName)) {
            Trace.out((String)"Failed to retrieve the CRS user using OCRDUMP");
            result.addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("9556", true)));
            result.setStatus(3);
            return null;
        }
        Trace.out((int)5, (String)("The CRS User name retrieved using OCR dump is " + usrName));
        result.setStatus(1);
        return usrName;
    }

    public static String getDefaultOperGroup() {
        VerificationLogData.logInfo("DefaultOperGroup: " + VDMUtil.getDefaultOperGroup());
        return VDMUtil.getDefaultOperGroup();
    }

    public static String getDefaultDbaGroup() {
        VerificationLogData.logInfo("DefaultDbaGroup: " + VDMUtil.getDefaultDbaGroup());
        return VDMUtil.getDefaultDbaGroup();
    }

    public static String getDefaultAsmGroup() {
        VerificationLogData.logInfo("DefaultDbaGroup: " + VDMUtil.getDefaultAsmGroup());
        return VDMUtil.getDefaultAsmGroup();
    }

    public static String getDefaultOraInvGroup() {
        VerificationLogData.logInfo("DefaultOraInvGroup: " + VDMUtil.getDefaultOraInvGroup());
        return VDMUtil.getDefaultOraInvGroup();
    }

    public static String getCVUQDiskGroup() {
        if (m_cvuQDiskGrp == null) {
            ParamManager pm = null;
            try {
                pm = ParamManager.getInstance();
            }
            catch (UninitializedParamManagerException e) {
                Trace.out((String)"Caught UninitializedParamManagerException - Ignoring");
            }
            if (pm != null) {
                m_cvuQDiskGrp = pm.getSinglePartArgVal(Argument.ARG_GROUP_ORAINV);
            }
            if (m_cvuQDiskGrp == null) {
                m_cvuQDiskGrp = VerificationUtil.getOraInventoryGroup();
            }
            if (m_cvuQDiskGrp == null) {
                m_cvuQDiskGrp = VerificationUtil.getDefaultOraInvGroup();
            }
        }
        return m_cvuQDiskGrp;
    }

    public static String getDefaultUmask() {
        return VDMUtil.getDefaultUmask();
    }

    public static String fetchTextByTags(String sfmtd, String start_tag, String end_tag) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, start_tag, end_tag);
    }

    public static String[] fetchTextByTagsRepeat(String sfmtd, String start_tag, String end_tag) {
        Vector<String> data = new Vector<String>();
        String tmpStr = null;
        sfmtd = sfmtd.trim();
        while (sfmtd.length() > 0 && (tmpStr = VerificationUtil.fetchTextByTags(sfmtd, start_tag, end_tag)) != null) {
            data.add(tmpStr);
            if (sfmtd.indexOf(end_tag) + end_tag.length() >= sfmtd.length()) break;
            sfmtd = sfmtd.substring(sfmtd.indexOf(end_tag) + end_tag.length());
            sfmtd = sfmtd.trim();
        }
        return data.toArray(new String[0]);
    }

    public static String fetchTextByTags(String sfmtd, String entity, String start_tag, String end_tag) {
        if (null == sfmtd || sfmtd.length() == 0) {
            return null;
        }
        String fmtdstr = null == entity || entity.trim().length() == 0 ? sfmtd : sfmtd;
        int begin = fmtdstr.indexOf(start_tag);
        if (begin == -1) {
            return null;
        }
        begin += start_tag.length();
        int end = fmtdstr.indexOf(end_tag);
        if (end == -1) {
            return null;
        }
        String data = fmtdstr.substring(begin, end);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nTags " + start_tag + " and " + end_tag + " contains:" + data + "\n"));
        }
        return data;
    }

    public static boolean fetchExecResult(String sfmtd) {
        int res;
        String eres = VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_ERES>", "</CV_ERES>");
        try {
            res = Integer.parseInt(eres);
        }
        catch (NumberFormatException e) {
            Trace.out((String)("Invalid exec result in the output. " + e.getMessage()));
            return false;
        }
        return res == 0;
    }

    public static String fetchVerificationResult(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_VRES>", "</CV_VRES>");
    }

    public static String fetchVerificationValue(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_VAL>", "</CV_VAL>");
    }

    public static boolean fetchVerificationStatus(String sfmtd) {
        String tagValue = VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_VRES>", "</CV_VRES>");
        return tagValue.equals("0");
    }

    public static String fetchCommandValue(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_CMD>", "</CV_CMD>");
    }

    public static String fetchError(String sfmtd) {
        String fmtErrStr = VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_ERR>", "</CV_ERR>");
        if (fmtErrStr == null) {
            Trace.out((String)"No errors to return.");
            return fmtErrStr;
        }
        StringBuffer retErrBuf = new StringBuffer();
        Object tmpStr = null;
        Trace.out((String)("Removing developer info from error message results: '" + fmtErrStr + "'"));
        if (fmtErrStr.indexOf("<SLOS_LOCINFOSTR>") != -1) {
            retErrBuf.append(VerificationUtil.fetchTextByTags(fmtErrStr, "<SLOS_LOCINFOSTR>", "</SLOS_LOCINFOSTR>") + "\n");
            fmtErrStr = VerificationUtil.removeTaggedSubstring("SLOS_LOCINFOSTR", fmtErrStr);
        }
        if (fmtErrStr.indexOf("<SLOS_DEPINFOSTR>") != -1) {
            retErrBuf.append(VerificationUtil.fetchTextByTags(fmtErrStr, "<SLOS_DEPINFOSTR>", "</SLOS_DEPINFOSTR>") + "\n");
            fmtErrStr = VerificationUtil.removeTaggedSubstring("SLOS_DEPINFOSTR", fmtErrStr);
        }
        if (fmtErrStr.indexOf("<SLOS_OTHERINFO>") != -1) {
            retErrBuf.append(VerificationUtil.fetchTextByTags(fmtErrStr, "<SLOS_OTHERINFO>", "</SLOS_OTHERINFO>") + "\n");
            fmtErrStr = VerificationUtil.removeTaggedSubstring("SLOS_OTHERINFO", fmtErrStr);
        }
        fmtErrStr = VerificationUtil.removeTaggedSubstring("SLOS_LOC", fmtErrStr);
        fmtErrStr = VerificationUtil.removeTaggedSubstring("SLOS_OP", fmtErrStr);
        fmtErrStr = VerificationUtil.removeTaggedSubstring("SLOS_CAT", fmtErrStr);
        if ((fmtErrStr = VerificationUtil.removeTaggedSubstring("SLOS_DEPINFO", fmtErrStr)) != null && fmtErrStr.length() > 0) {
            retErrBuf.append(fmtErrStr);
        }
        Trace.out((String)("Returning error string: '" + retErrBuf.toString() + "'"));
        return retErrBuf.toString();
    }

    private static String removeTaggedSubstring(String tag, String srcStr) {
        String startTag = new String("<" + tag + ">");
        String endTag = new String("</" + tag + ">");
        String newStr = srcStr;
        int startOffst = 0;
        int endOffst = 0;
        startOffst = srcStr.indexOf(startTag);
        endOffst = srcStr.indexOf(endTag);
        if (startOffst == -1 || endOffst == -1) {
            return srcStr;
        }
        Trace.out((int)1, (String)("Removing tag '<" + tag + ">' from '" + srcStr + "'"));
        newStr = startOffst == 0 ? (endOffst + endTag.length() >= srcStr.length() ? new String("") : srcStr.substring(endOffst + endTag.length())) : (endOffst + endTag.length() >= srcStr.length() ? srcStr.substring(0, startOffst) : srcStr.substring(0, startOffst) + srcStr.substring(endOffst + endTag.length()));
        Trace.out((int)1, (String)("Returning new string: '" + newStr + "'"));
        return newStr;
    }

    public static String fetchTrace(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_TRC>", "</CV_TRC>");
    }

    public static String fetchLog(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_LOG>", "</CV_LOG>");
    }

    public static String fetchProgressText(String sfmtd) {
        return VerificationUtil.fetchTextByTags(sfmtd, null, "<CV_PTXT>", "</CV_PTXT>");
    }

    public static String fetchCommandDetailsMessage(String node, String exectaskOutput) {
        String cmd = VerificationUtil.fetchCommandValue(exectaskOutput);
        String output = VerificationUtil.fetchVerificationValue(exectaskOutput);
        String exitVal = VerificationUtil.fetchVerificationResult(exectaskOutput);
        String msg = "";
        if (VerificationUtil.isStringGood(cmd) && VerificationUtil.isStringGood(exitVal)) {
            msg = VerificationUtil.isStringGood(output) ? s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{cmd, node, exitVal}) + LSEP + output : s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{cmd, node, exitVal});
        }
        Trace.out((String)("Message returned is:" + LSEP + msg));
        return msg;
    }

    public static String getSrcLoc() {
        String cvhome;
        String srcLoc = cvhome = VerificationUtil.getCVHome();
        Trace.out((String)("==== Source location is: " + srcLoc));
        return srcLoc;
    }

    public static String getCVHome() {
        if (s_cvhome != null) {
            return s_cvhome;
        }
        String prop = System.getProperty("CV_HOME");
        if (prop == null || prop.trim().length() <= 0) {
            prop = "." + FSEP;
        }
        if (!prop.endsWith(FSEP)) {
            prop = prop + FSEP;
        }
        s_cvhome = prop;
        return s_cvhome;
    }

    public static String getCurrentGroup() {
        if (s_currentGroup == null) {
            try {
                s_currentGroup = sVerificationUtil.getCurrentGroup();
            }
            catch (InvalidEnvironmentException e) {
                Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{((Object)((Object)e)).getClass(), e.getMessage()});
            }
        }
        return s_currentGroup;
    }

    public static void setCurrentGroup(String curGrp) {
        s_currentGroup = curGrp;
    }

    public static String getCVUSubDir() {
        if (VerificationUtil.isCVUResource()) {
            return "CVU_" + VerificationUtil.getRDBMSVersion() + "_" + "resource";
        }
        return "CVU_" + VerificationUtil.getRDBMSVersion() + "_" + System.getProperty("user.name");
    }

    public static String getCVUSubDirPath() {
        return VerificationUtil.getDestLoc() + VerificationUtil.getCVUSubDir() + FSEP;
    }

    public static String getDestLoc() {
        if (s_destloc != null) {
            Trace.out((String)("==== CV_DESTLOC(pre-fetched value): '" + s_destloc + "'"));
            return s_destloc;
        }
        String prop = System.getProperty("CV_DESTLOC");
        Trace.out((String)("==== CV_DESTLOC system property set as '" + prop + "'"));
        if (prop == null || prop.trim().length() <= 0) {
            Trace.out((String)"==== Null(or empty) CV_DESTLOC property.");
        } else if (!prop.endsWith(FSEP)) {
            prop = prop + FSEP;
        }
        s_destloc = prop;
        Trace.out((String)("==== CV_DESTLOC: '" + s_destloc + "'"));
        return s_destloc;
    }

    public static void setDestLoc(String destloc) {
        s_destloc = destloc;
        if (!s_destloc.endsWith(FSEP)) {
            s_destloc = s_destloc + FSEP;
        }
    }

    public static void setCVHome(String cvhome) {
        s_cvhome = cvhome;
        if (!s_cvhome.endsWith(FSEP)) {
            s_cvhome = s_cvhome + FSEP;
        }
    }

    public static String getTraceLoc() {
        if (s_traceloc != null) {
            return s_traceloc;
        }
        String prop = System.getProperty("CV_TRACELOC");
        if (prop == null || prop.trim().length() <= 0) {
            prop = VerificationUtil.getEnv("CV_TRACELOC");
        }
        if (Boolean.getBoolean("CV_ROOTUSERCHECK") && (prop == null || prop.trim().length() <= 0)) {
            prop = VerificationUtil.getDestLoc() + FSEP + "log" + FSEP;
        }
        if (prop == null || prop.trim().length() <= 0) {
            return null;
        }
        if (!prop.endsWith(FSEP)) {
            prop = prop + FSEP;
        }
        s_traceloc = prop;
        return s_traceloc;
    }

    public static String getCmd4RemExec() {
        String remExec = VDMUtil.getCmd4RemExec();
        Trace.out((String)("==== Remote Exec name: " + remExec));
        return remExec;
    }

    public static String[] getCmdFiles4RemExec() {
        return VDMUtil.getCmdFiles4RemExec();
    }

    public static String getCRSHome() {
        return VerificationUtil.getCRSHome(false);
    }

    public static String getCRSHomeFromInventory(Result result) {
        String inventoryFile = null;
        OUIData ouid = null;
        if (!VerificationUtil.isCRSConfigured()) {
            Trace.out((String)"getCRSHome() : Returning NULL as CRS is not found configured");
            result.setStatus(3);
            result.addErrorDescription(new ErrorDescription("7593", new String[]{result.getNode()}, s_msgBundle));
            return null;
        }
        try {
            inventoryFile = VerificationUtil.getInventoryFileLocation();
            ouid = OUIData.getInstance(inventoryFile);
        }
        catch (InvalidOUIInventoryDataException e) {
            Trace.out((String)("getCRSHome() : Returning NULL as encounterd InvalidOUIInventoryDataException: " + e.getMessage()));
            result.addErrorDescription(new ErrorDescription(e.getMessage()));
            result.setStatus(3);
            return null;
        }
        result.setStatus(1);
        return ouid.getCRSHomeLocation();
    }

    public static String getCRSHomeFromOCRDump(String crsHomeFromInv, String node, Result result) {
        if (!VerificationUtil.isStringGood(crsHomeFromInv)) {
            Trace.out((int)5, (String)"CRS home could not be retrieved from inventory hence returning null!");
            return null;
        }
        String crsHome = null;
        String homeOCRKey = "SYSTEM.ORA_CRS_HOME";
        result.setStatus(1);
        StringBuffer ocrKeyValue = VerificationUtil.getKeyValueFromOCRDump(crsHomeFromInv, "SYSTEM.ORA_CRS_HOME", result);
        if (ocrKeyValue != null && ocrKeyValue.length() > 0 && result.getStatus() == 1) {
            String[] lineByLine = VerificationUtil.string2strArr(ocrKeyValue.toString(), LINE_SEPARATOR);
            Pattern p = Pattern.compile("(\\s*)ORATEXT([^:]*):(\\s*)(.*)");
            for (String outputLine : lineByLine) {
                Matcher m = p.matcher(outputLine);
                if (!m.matches()) continue;
                crsHome = m.group(4);
                break;
            }
        }
        if (!VerificationUtil.isStringGood(crsHome)) {
            Trace.out((String)"Failed to retrieve the CRS home using OCRDUMP");
            result.addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("5301", true)));
            result.setStatus(3);
            return null;
        }
        Trace.out((int)5, (String)("The CRS home retrieved using OCR dump is " + crsHome));
        result.setStatus(1);
        return crsHome;
    }

    public static String getCRSHomeFromInitCSSD(String node, Result result) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            result.setStatus(2);
            return null;
        }
        String command = null;
        ErrorDescription errDesc = null;
        CommandsUtil cmdUtil = new CommandsUtil();
        ResultSet homeInfoRsltSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        boolean rslt = false;
        String crsHome = null;
        String cssdFileLocation = sVerificationUtil.getCSSDFileLoc();
        Trace.out((String)"The command Approach failed, now using Fallback (grep) approach");
        command = cmdUtil.getGrep() + " " + ORA_CRS_HOME + "= " + cssdFileLocation;
        homeInfoRsltSet.clear();
        rslt = globalExec.runExe(new String[]{node}, command, homeInfoRsltSet, false);
        if (rslt) {
            Result usrResult = (Result)homeInfoRsltSet.getResultTable().get(node);
            if (usrResult != null && usrResult.getStatus() == 1) {
                Vector resultInfoset = usrResult.getResultInfoSet();
                String homeStr = null;
                String exectaskOutput = null;
                if (resultInfoset.size() > 1 && (exectaskOutput = (String)resultInfoset.elementAt(1)) != null && VerificationUtil.fetchVerificationResult(exectaskOutput).equals("0") && (homeStr = VerificationUtil.fetchVerificationValue(exectaskOutput)) != null) {
                    homeStr = homeStr.trim();
                }
                if (homeStr == null || homeStr.length() == 0) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)"Failed, the command did not return success (CV Val is non-zero).");
                    }
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("5301", true));
                    result.addErrorDescription(errDesc);
                    result.setStatus(3);
                    return null;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("The Output returned from the command is :" + homeStr));
                }
                if (homeStr != null && homeStr.length() > 0) {
                    if (homeStr.contains("=")) {
                        int equalIndex = homeStr.indexOf("=");
                        crsHome = homeStr.length() > equalIndex ? homeStr.substring(equalIndex + 1) : null;
                    } else {
                        crsHome = homeStr;
                    }
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("The CRS home name returned from the command is :" + crsHome));
                }
                if (crsHome != null && crsHome.trim().length() > 0) {
                    result.setStatus(1);
                    return crsHome;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"The command run was successful but returned nothing.");
                }
                errDesc = new ErrorDescription(s_msgBundle.getMessage("5301", true));
                result.addErrorDescription(errDesc);
                result.setStatus(3);
                return null;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Failed to run the command.");
            }
            errDesc = new ErrorDescription(s_msgBundle.getMessage("5301", true));
            result.addErrorDescription(errDesc);
            result.setStatus(3);
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Failed in globalExec.runExe.");
        }
        errDesc = new ErrorDescription(s_msgBundle.getMessage("5301", true));
        result.addErrorDescription(errDesc);
        result.setStatus(2);
        return null;
    }

    public static String getCRSHome(boolean ignoreException) {
        String inventoryFile = null;
        OUIData ouid = null;
        if (!VerificationUtil.isCRSConfigured()) {
            Trace.out((String)"getCRSHome() : Returning NULL as CRS is not found configured");
            return null;
        }
        try {
            inventoryFile = VerificationUtil.getInventoryFileLocation();
            ouid = OUIData.getInstance(inventoryFile);
        }
        catch (InvalidOUIInventoryDataException e) {
            if (!ignoreException) {
                Trace.out((String)"getCRSHome(): ERROR instantiating the OUIData object");
                Trace.out((String)e.getMessage());
            }
            return null;
        }
        return ouid.getCRSHomeLocation();
    }

    public static String getInventoryFileLocation() throws InvalidOUIInventoryDataException {
        return new sVerificationUtil().getInventoryFileLocation();
    }

    public static boolean isHAInstalled() {
        boolean haInstalled = false;
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        String ouiLoc = VerificationUtil.getCVHome() + FSEP + "oui";
        String invPtrProp = null;
        invPtrProp = sVerificationUtil.getInventoryConfigFilePointer();
        if (invPtrProp != null && invPtrProp.trim().length() > 0) {
            String oldInvPtrProp;
            block5: {
                oldInvPtrProp = System.setProperty(ORA_INST_INVPTR_PROPERTY, invPtrProp.trim());
                try {
                    haInstalled = clustInfo.isHAInstalled(ouiLoc);
                    Trace.out((String)("haInstalled=" + haInstalled));
                }
                catch (InstallException ie) {
                    Trace.out((String)"Caught InstallException");
                    VerificationLogData.logError("INSTALLEXCEPTION: " + ie.getMessage() + "\n" + Trace.getStackTrace((Throwable)ie));
                    if (m_noReportException) break block5;
                    VerificationUtil.reportException((Exception)((Object)ie));
                }
            }
            if (oldInvPtrProp == null) {
                System.clearProperty(ORA_INST_INVPTR_PROPERTY);
            } else {
                System.setProperty(ORA_INST_INVPTR_PROPERTY, oldInvPtrProp);
            }
        }
        return haInstalled;
    }

    public static boolean isHAConfigured() {
        boolean haConfigured;
        block2: {
            haConfigured = false;
            ClusterwareInfo clustInfo = new ClusterwareInfo();
            try {
                haConfigured = clustInfo.isHAConfigured();
                Trace.out((String)("haConfigured=" + haConfigured));
            }
            catch (InstallException ie) {
                Trace.out((String)"Caught InstallException");
                VerificationLogData.logError("INSTALLEXCEPTION: " + ie.getMessage() + "\n" + Trace.getStackTrace((Throwable)ie));
                if (m_noReportException) break block2;
                VerificationUtil.reportException((Exception)((Object)ie));
            }
        }
        return haConfigured;
    }

    public static boolean isCRSConfigured() {
        boolean crsConfigured;
        block2: {
            crsConfigured = false;
            ClusterwareInfo clustInfo = new ClusterwareInfo();
            try {
                crsConfigured = clustInfo.isCRSConfigured();
                Trace.out((String)("crsConfigured=" + crsConfigured));
            }
            catch (InstallException ie) {
                Trace.out((String)"Caught InstallException");
                VerificationLogData.logError("INSTALLEXCEPTION: " + ie.getMessage() + "\n" + Trace.getStackTrace((Throwable)ie));
                if (m_noReportException) break block2;
                VerificationUtil.reportException((Exception)((Object)ie));
            }
        }
        return crsConfigured;
    }

    public static boolean isCRSInstalled() {
        boolean crsInstalled = false;
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        String ouiLoc = VerificationUtil.getCVHome() + FSEP + "oui";
        String invPtrProp = sVerificationUtil.getInventoryConfigFilePointer();
        if (invPtrProp != null && invPtrProp.trim().length() > 0) {
            String oldInvPtrProp;
            block5: {
                oldInvPtrProp = System.setProperty(ORA_INST_INVPTR_PROPERTY, invPtrProp.trim());
                try {
                    crsInstalled = clustInfo.isCRSInstalled(ouiLoc);
                    Trace.out((String)("crsInstalled=" + crsInstalled));
                }
                catch (InstallException ie) {
                    Trace.out((String)"Caught InstallException");
                    VerificationLogData.logError("INSTALLEXCEPTION: " + ie.getMessage() + "\n" + Trace.getStackTrace((Throwable)ie));
                    if (m_noReportException) break block5;
                    VerificationUtil.reportException((Exception)((Object)ie));
                }
            }
            if (oldInvPtrProp == null) {
                System.clearProperty(ORA_INST_INVPTR_PROPERTY);
            } else {
                System.setProperty(ORA_INST_INVPTR_PROPERTY, oldInvPtrProp);
            }
        }
        return crsInstalled;
    }

    public static String getHAHomeWithException() throws HAHomeNotFoundException {
        try {
            ClusterwareInfo cluInfo = new ClusterwareInfo();
            if (!cluInfo.isHAConfigured()) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"HA is not configured");
                }
                throw new HAHomeNotFoundException(s_msgBundle.getMessage("5318", true));
            }
        }
        catch (InstallException ie) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)(" Could not detemine whether HA is configured:" + ie.getMessage()));
            }
            throw new HAHomeNotFoundException(ie.getMessage());
        }
        return sVerificationUtil.getHAHomeWithException();
    }

    public static String getHAHome() {
        String haHome;
        block2: {
            haHome = null;
            try {
                haHome = VerificationUtil.getHAHomeWithException();
            }
            catch (HAHomeNotFoundException hae) {
                if (!Trace.isLevelEnabled((int)5)) break block2;
                Trace.out((String)("HA home can not be found:" + hae.getMessage()));
                Trace.out((Exception)hae);
            }
        }
        return haHome;
    }

    public static String getHAorCRSHome(String[] nodeList, String homeType, List<String> validNodes, ResultSet resultSet) {
        String exeHome = null;
        ErrorDescription errDesc = null;
        if (homeType.contentEquals(HA_HOME_REQ) || homeType.contentEquals(HA_OR_CRS_HOME_REQ)) {
            block18: {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"Attempt to get HA (OracleRestart) home");
                }
                try {
                    exeHome = VerificationUtil.getHAHomeWithException();
                }
                catch (HAHomeNotFoundException hae) {
                    if (!homeType.contentEquals(HA_HOME_REQ)) break block18;
                    String errMsg1 = hae.getMessage();
                    if (errMsg1 != null && errMsg1.length() > 0) {
                        ReportUtil.printError(errMsg1);
                    }
                    Trace.out((String)("\nHAHomeNotFoundEXCEPTION: \n" + hae));
                }
            }
            if (exeHome == null) {
                if (homeType.contentEquals(HA_HOME_REQ)) {
                    errDesc = new ErrorDescription("5307", s_msgBundle);
                    resultSet.addErrorDescription(errDesc);
                    ReportUtil.printError(errDesc.getErrorMessage());
                    resultSet.addResult(nodeList, 2);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)"\nReturning NULL HA (OracleRestart) home");
                    }
                    return null;
                }
            } else {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nReturning HA (OracleRestart) home: " + exeHome));
                }
                resultSet.addResult(nodeList, 1);
                validNodes.addAll(Arrays.asList(nodeList));
                return exeHome;
            }
        }
        if (homeType.contentEquals(CRS_HOME_REQ) || homeType.contentEquals(HA_OR_CRS_HOME_REQ) && exeHome == null) {
            String[] validNodeArr = null;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Attempt to get CRS home");
            }
            if ((exeHome = VerificationUtil.getCRSHome()) == null) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"Failed to retrieve CRS home");
                }
                errDesc = new ErrorDescription("5301", s_msgBundle);
                resultSet.addErrorDescription(errDesc);
                ReportUtil.printError(errDesc.getErrorMessage());
                resultSet.addResult(nodeList, 2);
                return null;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\nReturning CRS home: " + exeHome));
            }
            if ((validNodeArr = VerificationUtil.getNodesWithCRSInstall(nodeList, resultSet)) == null) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"CRS is not installed on any given node");
                }
                resultSet.addResult(nodeList, 2);
                return null;
            }
            resultSet.addResult(validNodeArr, 1);
            validNodes.addAll(Arrays.asList(validNodeArr));
            return exeHome;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Failed to retrieve HA (OracleRestart) orCRS home");
        }
        errDesc = new ErrorDescription("5321", s_msgBundle);
        resultSet.addErrorDescription(errDesc);
        ReportUtil.printError(errDesc.getErrorMessage());
        resultSet.addResult(nodeList, 2);
        return null;
    }

    public static boolean isCRSInstalledOnNode(String node) {
        String[] ndList = new String[]{node};
        Vector<String> sucV = new Vector<String>(1);
        Vector<String> failV = new Vector<String>(1);
        return VerificationUtil.isCRSInstalled(ndList, sucV, failV);
    }

    public static boolean isCRSInstalledOnLocalNode() throws UnknownHostException {
        String localNd = VerificationUtil.getLocalHost();
        String[] ndList = new String[]{localNd};
        Vector<String> sucV = new Vector<String>(1);
        Vector<String> failV = new Vector<String>(1);
        return VerificationUtil.isCRSInstalled(ndList, sucV, failV);
    }

    public static boolean isCRSInstalled(String[] nodeList, Vector<String> succNodeVect, Vector<String> failNodeVect) {
        return VerificationUtil.isCRSInstalled(nodeList, succNodeVect, failNodeVect, false);
    }

    public static boolean isCRSInstalled(String[] nodeList, Vector<String> succNodeVect, Vector<String> failNodeVect, boolean mute) {
        Trace.out((String)("nodeList='" + VerificationUtil.strArr2List(nodeList) + "'"));
        VerificationLogData.logFine(LSEP + "nodeList='" + VerificationUtil.strArr2List(nodeList) + "'");
        succNodeVect.clear();
        failNodeVect.clear();
        try {
            VerificationUtil.getNodelistFromOlsnodesWithException();
        }
        catch (NodelistNotFoundException e) {
            if (!mute) {
                ReportUtil.printError(e.getMessage());
            }
            Trace.out((String)("IGNORED: " + e.getClass() + ": " + e.getMessage()));
        }
        for (String node : nodeList) {
            boolean foundNode = false;
            for (String olsNodeArrElem : m_nodeListFromOlsnodes) {
                if (!olsNodeArrElem.equalsIgnoreCase(VerificationUtil.getShortHostname(node))) continue;
                Trace.out((String)("CRS found installed  on node (olsnodes): " + node));
                succNodeVect.add(node);
                foundNode = true;
                break;
            }
            if (foundNode) continue;
            Trace.out((String)("Not found in olsnodes & inventory: " + node));
            failNodeVect.add(node);
        }
        return failNodeVect.size() == 0;
    }

    public static boolean isDirWritable(Collection<String> nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        String[] tempNodeList = nodeList.toArray(new String[nodeList.size()]);
        return VerificationUtil.pathExists(tempNodeList, path, 4, succNodes, failNodes);
    }

    public static boolean isDirWritable(String[] nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        return VerificationUtil.pathExists(nodeList, path, 4, succNodes, failNodes);
    }

    public static boolean isDirPathWritable(String[] nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if (VerificationUtil.pathExists(nodeList, path, 4, succNodes, failNodes)) {
            return true;
        }
        if (VerificationUtil.pathExists(nodeList, path, 1, succNodes, failNodes)) {
            return false;
        }
        if (path.lastIndexOf(FSEP) == -1) {
            return false;
        }
        String parent = path.substring(0, path.lastIndexOf(FSEP));
        while (true) {
            Trace.out((String)("Checking path: '" + parent + "'"));
            if (VerificationUtil.pathExists(nodeList, parent, 4, succNodes, failNodes)) {
                return true;
            }
            if (VerificationUtil.pathExists(nodeList, parent, 1, succNodes, failNodes)) {
                return false;
            }
            if (parent.lastIndexOf(FSEP) == -1) {
                return false;
            }
            if (parent.length() == parent.lastIndexOf(FSEP) + 1) break;
            if ((parent = parent.substring(0, parent.lastIndexOf(FSEP))).charAt(parent.length() - 1) != ':' || !VerificationUtil.getCurrentOS().toLowerCase().startsWith("windows") || parent.length() != 2) continue;
            parent = new String(parent + FSEP);
            Trace.out((String)("Added '" + FSEP + "' to: '" + parent + "'"));
        }
        return false;
    }

    private static boolean dirExists(Collection<String> nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        String[] tempNodeList = nodeList.toArray(new String[nodeList.size()]);
        return VerificationUtil.pathExists(tempNodeList, path, 1, succNodes, failNodes);
    }

    private static boolean pathExists(Collection<String> nodeList, String path, Collection<String> succNodes, Collection<String> failNodes) {
        String[] tempNodeList = nodeList.toArray(new String[nodeList.size()]);
        return VerificationUtil.pathExists(tempNodeList, path, 0, succNodes, failNodes);
    }

    public static boolean pathExists(String[] nodeList, String path, int pathType, Collection<String> succNodes, Collection<String> failNodes) {
        boolean succ;
        block10: {
            ClusterCmd clusterCmd = new ClusterCmd();
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ENTRY");
            }
            succNodes.clear();
            failNodes.clear();
            Trace.out((String)("nodeList: '" + VerificationUtil.strArr2List(nodeList) + "' path: '" + path + "' pathType: '" + pathType + "' isLocalNodeOperation(): '" + VerificationUtil.isLocalNodeOperation() + "'"));
            try {
                succ = VerificationUtil.isLocalNodeOperation() ? clusterCmd.pathExists(new String[]{"localnode"}, path, pathType) : clusterCmd.pathExists(nodeList, path, pathType);
                if (!succ) break block10;
                for (int i = 0; i < nodeList.length; ++i) {
                    succNodes.add(nodeList[i]);
                }
            }
            catch (ClusterException ce) {
                Trace.out((String)("Exception occured: \n" + (Object)((Object)ce)));
                succ = false;
                VerificationLogData.logError("CLUSTEREXCEPTION: " + ce.getMessage() + LSEP + Trace.getStackTrace((Throwable)ce));
                for (int i = 0; i < nodeList.length; ++i) {
                    failNodes.add(nodeList[i]);
                }
            }
            catch (ClusterOperationException coe) {
                Trace.out((String)("Didn't expect ClusterOperationException " + (Object)((Object)coe)));
                succ = false;
                for (int i = 0; i < nodeList.length; ++i) {
                    try {
                        int status = coe.getStatus(nodeList[i]);
                        if (0 == status) {
                            succNodes.add(nodeList[i]);
                            continue;
                        }
                        failNodes.add(nodeList[i]);
                        if (2 != status) continue;
                        Trace.out((String)coe.getException(nodeList[i]).getMessage());
                        VerificationLogData.logError("CLUSTEROPERATIONEXCEPTION: " + coe.getException(nodeList[i]).getMessage() + LSEP + Trace.getStackTrace((Throwable)coe.getException(nodeList[i])));
                        continue;
                    }
                    catch (NoSuchNodeException ns) {
                        Trace.out((String)("\n UNEXPECTED::: \n" + (Object)((Object)ns)));
                        failNodes.add(nodeList[i]);
                        VerificationLogData.logError("NOSUCHNODEEXCEPTION: " + ns.getMessage() + LSEP + Trace.getStackTrace((Throwable)ns));
                    }
                }
            }
        }
        Trace.out((String)"returning success");
        return succ;
    }

    public static boolean checkDestLoc(String[] nodeList, ResultSet resultSet, Collection<String> succNodes, Collection<String> failNodes, boolean report) {
        ErrorDescription errDesc;
        String node2;
        String[] tempNodeList;
        Object[] args;
        Vector<String> wDLNodes = new Vector<String>();
        Vector<String> noWDLNodes = new Vector<String>();
        String destLoc = VerificationUtil.getDestLoc();
        String subDirPath = VerificationUtil.getCVUSubDirPath();
        ResultSet verResultSet = new ResultSet();
        Vector<String> incompatibleNodes = new Vector<String>();
        ClusterCmd clusterCmd = new ClusterCmd();
        ArrayList<String> succNodesLocal = new ArrayList<String>();
        Trace.out((String)("destloc is--->" + destLoc));
        Trace.out((String)("subDirPath is--->" + subDirPath));
        succNodes.clear();
        failNodes.clear();
        if (nodeList == null || nodeList.length == 0) {
            return false;
        }
        try {
            ClusterCmd cmd = new ClusterCmd();
            cmd.createDirWithModeOnNodes(nodeList, subDirPath);
        }
        catch (ClusterException e) {
            Trace.out((String)("ce exception occurred when trying to create CV_DESTLOC:" + e.getMessage()));
            VerificationLogData.logError("CLUSTEREXCEPTION: " + e.getMessage() + LSEP + Trace.getStackTrace((Throwable)e));
        }
        VerificationUtil.isDirWritable(nodeList, destLoc, wDLNodes, noWDLNodes);
        if (wDLNodes.size() > 0) {
            Vector<String> wSubDirNodes = new Vector<String>();
            Vector<String> noWSubDirNodes = new Vector<String>();
            VerificationUtil.isDirWritable(wDLNodes, subDirPath, wSubDirNodes, noWSubDirNodes);
            succNodesLocal.addAll(wSubDirNodes);
            if (noWSubDirNodes.size() > 0) {
                Vector<String> subDirNodes = new Vector<String>();
                Vector<String> noSubDirNodes = new Vector<String>();
                VerificationUtil.dirExists(noWSubDirNodes, subDirPath, subDirNodes, noSubDirNodes);
                succNodesLocal.addAll(noSubDirNodes);
                if (subDirNodes.size() > 0) {
                    if (report) {
                        args = new String[]{subDirPath};
                        ReportUtil.printError(s_msgBundle.getMessage("9013", false, args));
                        ReportUtil.sureprintNodelist(subDirNodes);
                    }
                    failNodes.addAll(subDirNodes);
                    tempNodeList = subDirNodes.toArray(new String[subDirNodes.size()]);
                    resultSet.addResult(tempNodeList, 2);
                    for (String node2 : subDirNodes) {
                        errDesc = new ErrorDescription(s_msgBundle.getMessage("7546", false, (Object[])new String[]{destLoc, node2}), s_msgBundle.getMessage("7547", false, (Object[])new String[]{subDirPath}), s_msgBundle.getMessage("7548", false));
                        resultSet.addErrorDescription(node2, errDesc);
                    }
                }
            }
        }
        if (noWDLNodes.size() > 0) {
            Vector<String> dLNodes = new Vector<String>();
            Vector<String> noDLNodes = new Vector<String>();
            VerificationUtil.pathExists(noWDLNodes, destLoc, dLNodes, noDLNodes);
            if (dLNodes.size() > 0) {
                failNodes.addAll(dLNodes);
                tempNodeList = dLNodes.toArray(new String[dLNodes.size()]);
                resultSet.addResult(tempNodeList, 2);
                if (report) {
                    args = new String[]{destLoc};
                    ReportUtil.printError(s_msgBundle.getMessage("9012", false, args));
                    ReportUtil.sureprintNodelist(dLNodes);
                }
                for (String node2 : dLNodes) {
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7546", false, (Object[])new String[]{destLoc, node2}), s_msgBundle.getMessage("7549", false, (Object[])new String[]{destLoc}), s_msgBundle.getMessage("7548", false));
                    resultSet.addErrorDescription(node2, errDesc);
                }
            }
            if (noDLNodes.size() > 0) {
                Vector<String> wParentNodes = new Vector<String>();
                Vector<String> noWParentNodes = new Vector<String>();
                String destLocParent = new File(destLoc).getParent();
                VerificationUtil.isDirWritable(noDLNodes, destLocParent, wParentNodes, noWParentNodes);
                succNodesLocal.addAll(wParentNodes);
                if (noWParentNodes.size() > 0) {
                    failNodes.addAll(noWParentNodes);
                    tempNodeList = noWParentNodes.toArray(new String[noWParentNodes.size()]);
                    resultSet.addResult(tempNodeList, 2);
                    if (report) {
                        args = new String[]{destLoc};
                        ReportUtil.printError(s_msgBundle.getMessage("9014", false, args));
                        ReportUtil.sureprintNodelist(noWParentNodes);
                    }
                    for (String node2 : noWParentNodes) {
                        errDesc = new ErrorDescription(s_msgBundle.getMessage("7546", false, (Object[])new String[]{destLoc, node2}), s_msgBundle.getMessage("7550", false, (Object[])new String[]{destLoc, node2}), s_msgBundle.getMessage("7548", false));
                        resultSet.addErrorDescription(node2, errDesc);
                    }
                }
            }
        }
        if (succNodesLocal.size() > 0) {
            tempNodeList = succNodesLocal.toArray(new String[succNodesLocal.size()]);
            resultSet.addResult(tempNodeList, 1);
        }
        if (failNodes.size() > 0) {
            if (1 == nodeList.length) {
                args = null;
                if (report) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("9016", false, args));
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0007", false));
                }
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7552", false, (Object[])new String[]{destLoc}));
                errDesc.setCause(s_msgBundle.getMessage("7553", false));
                errDesc.setAction(s_msgBundle.getMessage("7554", false));
                resultSet.addErrorDescription(errDesc);
            } else if (failNodes.size() == nodeList.length) {
                args = null;
                if (report) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("9016", false, args));
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0007", false));
                }
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7551", false, (Object[])new String[]{destLoc}));
                errDesc.setCause(s_msgBundle.getMessage("7553", false));
                errDesc.setAction(s_msgBundle.getMessage("7554", false));
                resultSet.addErrorDescription(errDesc);
            } else if (report) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                ReportUtil.sureprintNodelist(new Vector(succNodesLocal));
            }
        }
        if (succNodesLocal.size() == 0) {
            return false;
        }
        tempNodeList = succNodesLocal.toArray(new String[succNodesLocal.size()]);
        new GlobalExecution().getExectaskVer(tempNodeList, verResultSet);
        Trace.out((String)"VerificationUtil::   getExectaskVer() performed!!");
        succNodesLocal.clear();
        failNodes.clear();
        incompatibleNodes.clear();
        VerificationUtil.checkGetExectaskVerResults(resultSet, verResultSet, succNodesLocal, failNodes, incompatibleNodes, report);
        if (incompatibleNodes.size() != 0) {
            Trace.out((String)("The exectask is found to be incompatiable on nodes: " + VerificationUtil.strVect2List(incompatibleNodes)));
            tempNodeList = incompatibleNodes.toArray(new String[incompatibleNodes.size()]);
            for (int i = 0; i < tempNodeList.length; ++i) {
                node2 = tempNodeList[i];
                boolean succ = false;
                try {
                    succ = clusterCmd.removeDirectory(new String[]{node2}, subDirPath, true);
                    if (!succ) continue;
                    Trace.out((String)("Successfully deleted the contents of directory '" + subDirPath + "' on node '" + node2 + "'"));
                    Vector<String> newSuccNode = new Vector<String>();
                    Vector<String> newFailNode = new Vector<String>();
                    Vector<String> newIncompatibleNode = new Vector<String>();
                    Trace.out((String)("Populating destloc with new exectask on node :" + node2));
                    new GlobalExecution().getExectaskVer(new String[]{node2}, verResultSet);
                    VerificationUtil.checkGetExectaskVerResults(resultSet, verResultSet, newSuccNode, newFailNode, newIncompatibleNode, report);
                    if (newSuccNode.size() != 0) {
                        Trace.out((String)("Compatible exectask copied to node :" + node2));
                        succNodesLocal.add(node2);
                        continue;
                    }
                    Trace.out((String)("Incompatible exectask. New exectask couldn't be copied to node :" + node2));
                    failNodes.add(node2);
                    resultSet.addResult(node2, 2);
                    continue;
                }
                catch (ClusterException ce) {
                    Trace.out((String)("Exception occured: \n" + (Object)((Object)ce)));
                    VerificationLogData.logError("CLUSTEREXCEPTION: " + ce.getMessage() + LSEP + Trace.getStackTrace((Throwable)ce));
                    Trace.out((String)("Failure in deleting contents of directory '" + subDirPath + "' on node '" + node2 + "'"));
                    failNodes.add(node2);
                    resultSet.addResult(node2, 2);
                    if (report) {
                        ReportUtil.printError(s_msgBundle.getMessage("7546", false, (Object[])new String[]{destLoc, node2}) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    }
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7546", false, (Object[])new String[]{destLoc, node2}), s_msgBundle.getMessage("7555", false, (Object[])new String[]{subDirPath}), s_msgBundle.getMessage("7548", false));
                    resultSet.addErrorDescription(node2, errDesc);
                }
            }
        }
        if (succNodesLocal.size() > 0) {
            ArrayList<String> remExecFailNodes = new ArrayList<String>();
            VerificationUtil.checkRemExecFileList(succNodesLocal, remExecFailNodes, resultSet);
            if (remExecFailNodes.size() != 0) {
                Trace.out((String)("Some of the remote files are found missing on nodes: " + VerificationUtil.strCollection2String(remExecFailNodes)));
                tempNodeList = remExecFailNodes.toArray(new String[remExecFailNodes.size()]);
                for (int i = 0; i < tempNodeList.length; ++i) {
                    node2 = tempNodeList[i];
                    boolean succ = false;
                    try {
                        succ = clusterCmd.removeDirectory(new String[]{node2}, subDirPath, true);
                        if (!succ) continue;
                        Trace.out((String)("Successfully deleted the contents of directory '" + subDirPath + "' on node '" + node2 + "'"));
                        Vector<String> newSuccNode = new Vector<String>();
                        Vector<String> newFailNode = new Vector<String>();
                        Vector<String> newIncompatibleNode = new Vector<String>();
                        ResultSet remVerResultSet = new ResultSet();
                        Trace.out((String)("Populating destloc with new exectask on node :" + node2));
                        new GlobalExecution().getExectaskVer(new String[]{node2}, remVerResultSet);
                        VerificationUtil.checkGetExectaskVerResults(resultSet, remVerResultSet, newSuccNode, newFailNode, newIncompatibleNode, report);
                        if (newSuccNode.size() != 0) {
                            Trace.out((String)("Populating destloc with new exectask on node :" + node2));
                            remExecFailNodes.remove(node2);
                            resultSet.addResult(node2, new Result(node2, 1));
                            continue;
                        }
                        Trace.out((String)("Incompatible exectask. New exectask couldn't be copied to node :" + node2));
                        resultSet.addResult(node2, 2);
                        continue;
                    }
                    catch (ClusterException ce) {
                        Trace.out((String)("Exception occured: \n" + (Object)((Object)ce)));
                        VerificationLogData.logError("CLUSTEREXCEPTION: " + ce.getMessage() + LSEP + Trace.getStackTrace((Throwable)ce));
                        VerificationLogData.logError("Failure in deleting contents of directory '" + subDirPath + "' on node '" + node2 + "'");
                        Trace.out((String)("Failure in deleting contents of directory '" + subDirPath + "' on node '" + node2 + "'"));
                        succNodesLocal.remove(node2);
                        resultSet.addResult(node2, 2);
                        if (report) {
                            ReportUtil.printError(s_msgBundle.getMessage("7546", false, (Object[])new String[]{destLoc, node2}) + LSEP);
                        }
                        errDesc = new ErrorDescription(s_msgBundle.getMessage("7546", false, (Object[])new String[]{destLoc, node2}), s_msgBundle.getMessage("7555", false, (Object[])new String[]{subDirPath}), s_msgBundle.getMessage("7548", false));
                        resultSet.addErrorDescription(node2, errDesc);
                    }
                }
            }
            if (remExecFailNodes.size() != 0) {
                String errorMsg = s_msgBundle.getMessage("7650", false, (Object[])new String[]{subDirPath});
                if (report) {
                    ReportUtil.printError(errorMsg);
                    ReportUtil.sureprintNodelist(remExecFailNodes.toArray(new String[0]));
                }
                succNodesLocal.removeAll(remExecFailNodes);
                if (report && succNodesLocal.size() > 0) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                    ReportUtil.sureprintNodelist(new Vector<String>(succNodesLocal));
                }
            }
        }
        if (succNodesLocal.size() == 0) {
            if (report) {
                ReportUtil.printError(s_msgBundle.getMessage("7560", false) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            }
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7560", false));
            resultSet.addErrorDescription(errDesc);
        } else {
            VerificationUtil.setLocalNodeFirst(succNodesLocal);
            succNodes.addAll(succNodesLocal);
        }
        resultSet.traceResultSet("Before return from checkDestLoc with #succNodes=" + succNodes.size() + ";#failNodes=" + failNodes.size() + ";#nodes=" + nodeList.length);
        return succNodes.size() == nodeList.length;
    }

    private static void checkRemExecFileList(Collection<String> succNodes, Collection<String> failNodes, ResultSet resultSet) {
        String[] remExecFiles;
        HashSet<String> failedNodeSet = new HashSet<String>();
        String[] nodeArr = succNodes.toArray(new String[0]);
        ArrayList<String> remExecFileList = new ArrayList<String>();
        for (String remExecFile : remExecFiles = VerificationUtil.getCmdFiles4RemExec()) {
            remExecFileList.add(VerificationUtil.getDestLoc() + VerificationUtil.getCVUSubDir() + FSEP + new File(remExecFile).getName());
        }
        ResultSet fileInfoResultSet = new ResultSet();
        boolean fileInfoResult = new GlobalExecution().getFileInfo(nodeArr, remExecFileList, fileInfoResultSet);
        Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfo = new Hashtable<String, Hashtable<String, FileInfo>>();
        if (!fileInfoResult) {
            fileInfoResultSet.addResult(nodeArr, 2);
            ErrorDescription errDesc = new ErrorDescription("4160", s_msgBundle);
            fileInfoResultSet.addErrorDescription(nodeArr, errDesc);
            failNodes.addAll(succNodes);
            resultSet.addResult(failNodes, 2);
        } else {
            Hashtable fileInforResultTable = fileInfoResultSet.getResultTable();
            for (String node1 : nodeArr) {
                Result result = (Result)fileInforResultTable.get(node1);
                if (result == null || result.getStatus() != 1) continue;
                Hashtable nodeFileList = (Hashtable)result.getResultInfoSet().elementAt(0);
                nodeFileInfo.put(node1, nodeFileList);
            }
            for (String file : remExecFileList) {
                Hashtable<String, List<String>> failedNodes = VerificationUtil.checkFileAttributes(nodeArr, file, nodeFileInfo, null, null, null, resultSet);
                failedNodeSet.addAll(failedNodes.keySet());
                if (failedNodes.keySet().size() <= 0) continue;
                Trace.out((String)("file " + file + " missing on " + failedNodes.keySet()));
            }
            failNodes.addAll(failedNodeSet);
        }
    }

    public static void setLocalNodeFirst(List<String> nodeList) {
        if (nodeList.contains(m_localHostName)) {
            nodeList.remove(m_localHostName);
            nodeList.add(0, m_localHostName);
        }
    }

    public static Hashtable<String, Hashtable<String, FileInfo>> getFileAttributes(String[] validNodeArr, String file, ResultSet resultSet) {
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add(file);
        return VerificationUtil.getFileAttributes(validNodeArr, fileList, null, null, null, resultSet);
    }

    public static Hashtable<String, Hashtable<String, FileInfo>> getFileAttributes(String[] validNodeArr, List<String> fileList, String refOwner, String refGroup, String refPermissions, ResultSet resultSet) {
        Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfo = new Hashtable<String, Hashtable<String, FileInfo>>();
        if (fileList.size() > 0) {
            GlobalExecution globalExec = new GlobalExecution();
            ResultSet fileInfoResultSet = new ResultSet();
            boolean fileInfoResult = globalExec.getFileInfo(validNodeArr, fileList, fileInfoResultSet);
            resultSet.uploadResultSet(fileInfoResultSet);
            Trace.out((String)"After calling globalExec.getFileInfo() ... ");
            if (!fileInfoResult) {
                ReportUtil.printError(s_msgBundle.getMessage("4160", false));
                resultSet.addResult(validNodeArr, 2);
                ErrorDescription errDesc = new ErrorDescription("4160", s_msgBundle);
                resultSet.addErrorDescription(errDesc);
                return null;
            }
            Hashtable fileInforResultTable = fileInfoResultSet.getResultTable();
            for (String node : validNodeArr) {
                Result result = (Result)fileInforResultTable.get(node);
                if (result == null || result.getStatus() != 1) continue;
                Hashtable nodeFileList = (Hashtable)result.getResultInfoSet().elementAt(0);
                nodeFileInfo.put(node, nodeFileList);
            }
        }
        return nodeFileInfo;
    }

    public static Hashtable<String, List<String>> checkFileAttributes(String[] validNodeArr, String file, Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfoTable, String refOwner, String refGroup, String refPermissions, ResultSet resultSet) {
        return VerificationUtil.checkFileAttributes(validNodeArr, file, null, nodeFileInfoTable, refOwner, refGroup, refPermissions, resultSet);
    }

    public static Hashtable<String, List<String>> checkFileAttributes(String[] validNodeArr, String file, String fileDescription, Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfoTable, String refOwner, String refGroup, String refPermissions, ResultSet resultSet) {
        Enumeration e;
        FileInfo nodeFileInfo;
        Hashtable<String, List<String>> failedNodes = new Hashtable<String, List<String>>();
        Hashtable<String, ArrayList<String>> consistOwner = new Hashtable<String, ArrayList<String>>();
        Hashtable<String, ArrayList<String>> consistGroup = new Hashtable<String, ArrayList<String>>();
        Hashtable<String, ArrayList<String>> consistPerms = new Hashtable<String, ArrayList<String>>();
        List<Object> nodeErrors = null;
        ArrayList<CollectionElement> fileCollectionElementList = new ArrayList<CollectionElement>();
        for (String node : validNodeArr) {
            nodeErrors = new ArrayList<String>();
            Hashtable<String, FileInfo> nodeFileList = nodeFileInfoTable.get(node);
            CollectionElement fileCollectionElement = new CollectionElement(file, null, null, null, fileDescription, 1);
            if (new SystemFactory().CreateSystem().isUnixSystem()) {
                resultSet.addCollectionElement(node, fileCollectionElement);
                fileCollectionElementList.add(fileCollectionElement);
            }
            String referenceValue = null;
            if (refOwner != null) {
                referenceValue = "Owner=" + refOwner;
            }
            if (refGroup != null) {
                referenceValue = referenceValue != null ? referenceValue + "; Group=" + refGroup : "Group=" + refGroup;
            }
            if (refPermissions != null) {
                referenceValue = referenceValue != null ? referenceValue + "; Permissions=" + refPermissions : "Permissions=" + refPermissions;
            }
            fileCollectionElement.setExpectedValue(referenceValue);
            if (nodeFileList != null && nodeFileList.size() > 0) {
                ErrorDescription error;
                String errorMessage;
                boolean nodeFailed = false;
                nodeFileInfo = nodeFileList.get(file);
                if ("1".equals(nodeFileInfo.getStatus())) {
                    resultSet.addResult(node, 3);
                    ErrorDescription error2 = new ErrorDescription(nodeFileInfo.getErrorString());
                    resultSet.addErrorDescription(node, error2);
                    nodeErrors.add(nodeFileInfo.getErrorString());
                    failedNodes.put(node, nodeErrors);
                    nodeFailed = true;
                    fileCollectionElement.setStatus(3);
                    fileCollectionElement.addErrorDescription(error2);
                    continue;
                }
                String nodeValue = "Owner=" + nodeFileInfo.getFileOwner() + "; Group=" + nodeFileInfo.getFileGroup() + "; Permissions=" + nodeFileInfo.getFilePermissions();
                fileCollectionElement.setValue(nodeValue);
                Trace.out((String)("Checking file: " + nodeFileInfo.getFileName() + "\n Owner: " + nodeFileInfo.getFileOwner() + "\n Group: " + nodeFileInfo.getFileGroup() + "\n Perms: " + nodeFileInfo.getFilePermissions() + "\n"));
                if (refOwner != null && refOwner.length() > 0) {
                    if (!nodeFileInfo.getFileOwner().equalsIgnoreCase(refOwner)) {
                        resultSet.addResult(node, 3);
                        errorMessage = s_gMsgBundle.getMessage("2031", false, (Object[])new String[]{nodeFileInfo.getFileName(), node, refOwner, nodeFileInfo.getFileOwner()});
                        error = new ErrorDescription(errorMessage);
                        resultSet.addErrorDescription(node, error);
                        nodeErrors.add(errorMessage);
                        fileCollectionElement.setStatus(3);
                        fileCollectionElement.addErrorDescription(error);
                        nodeFailed = true;
                    }
                } else {
                    ArrayList<String> ownerNodes = null;
                    if (nodeFileInfo.getFileOwner() != null) {
                        ownerNodes = (ArrayList<String>)consistOwner.get(nodeFileInfo.getFileOwner());
                        if (ownerNodes == null) {
                            ownerNodes = new ArrayList<String>();
                        }
                        ownerNodes.add(node);
                        consistOwner.put(nodeFileInfo.getFileOwner(), ownerNodes);
                    }
                }
                if (refGroup != null && refGroup.length() > 0) {
                    if (!nodeFileInfo.getFileGroup().equalsIgnoreCase(refGroup)) {
                        resultSet.addResult(node, 3);
                        errorMessage = s_gMsgBundle.getMessage("2032", false, (Object[])new String[]{nodeFileInfo.getFileName(), node, refGroup, nodeFileInfo.getFileGroup()});
                        error = new ErrorDescription(errorMessage);
                        resultSet.addErrorDescription(node, error);
                        nodeErrors.add(errorMessage);
                        fileCollectionElement.setStatus(3);
                        fileCollectionElement.addErrorDescription(error);
                        nodeFailed = true;
                    }
                } else {
                    ArrayList<String> groupNodes = null;
                    if (nodeFileInfo.getFileGroup() != null) {
                        groupNodes = (ArrayList<String>)consistGroup.get(nodeFileInfo.getFileGroup());
                        if (groupNodes == null) {
                            groupNodes = new ArrayList<String>();
                        }
                        groupNodes.add(node);
                        consistGroup.put(nodeFileInfo.getFileGroup(), groupNodes);
                    }
                }
                if (refPermissions != null && refPermissions.length() > 0) {
                    if (!nodeFileInfo.getFilePermissions().equalsIgnoreCase(refPermissions)) {
                        resultSet.addResult(node, 3);
                        errorMessage = s_gMsgBundle.getMessage("2033", false, (Object[])new String[]{nodeFileInfo.getFileName(), node, refPermissions, nodeFileInfo.getFilePermissions()});
                        error = new ErrorDescription(errorMessage);
                        resultSet.addErrorDescription(node, error);
                        fileCollectionElement.setStatus(3);
                        fileCollectionElement.addErrorDescription(error);
                        nodeErrors.add(errorMessage);
                        nodeFailed = true;
                    }
                } else {
                    ArrayList<String> permNodes = null;
                    if (nodeFileInfo.getFilePermissions() != null) {
                        permNodes = (ArrayList<String>)consistPerms.get(nodeFileInfo.getFilePermissions());
                        if (permNodes == null) {
                            permNodes = new ArrayList<String>();
                        }
                        permNodes.add(node);
                        consistPerms.put(nodeFileInfo.getFilePermissions(), permNodes);
                    }
                }
                if (!nodeFailed) continue;
                failedNodes.put(node, nodeErrors);
                continue;
            }
            String error = s_msgBundle.getMessage("4160", false);
            nodeErrors.add(error);
            failedNodes.put(node, nodeErrors);
        }
        if ((refOwner == null || refOwner != null && refOwner.length() == 0) && consistOwner.keySet().size() > 1) {
            e = consistOwner.keys();
            while (e.hasMoreElements()) {
                String owner = (String)e.nextElement();
                List ownerNodes = (List)consistOwner.get(owner);
                for (String ownNode : ownerNodes) {
                    Hashtable<String, FileInfo> nodeFileList = nodeFileInfoTable.get(ownNode);
                    if (nodeFileList == null || "1".equals((nodeFileInfo = nodeFileList.get(file)).getStatus())) continue;
                    resultSet.addResult(ownNode, 3);
                    String errorMessage = s_gMsgBundle.getMessage("2027", false, (Object[])new String[]{nodeFileInfo.getFileName(), owner});
                    ErrorDescription error = new ErrorDescription(errorMessage);
                    resultSet.addErrorDescription(error);
                    for (CollectionElement element : fileCollectionElementList) {
                        element.setStatus(3);
                        element.addErrorDescription(error);
                    }
                    nodeErrors = failedNodes.get(ownNode);
                    if (nodeErrors == null) {
                        nodeErrors = new ArrayList();
                    }
                    nodeErrors.add(errorMessage);
                    failedNodes.put(ownNode, nodeErrors);
                }
            }
        }
        if ((refGroup == null || refGroup != null && refGroup.length() == 0) && consistGroup.keySet().size() > 1) {
            e = consistGroup.keys();
            while (e.hasMoreElements()) {
                String group = (String)e.nextElement();
                List grpNodes = (List)consistGroup.get(group);
                for (String grpNode : grpNodes) {
                    Hashtable<String, FileInfo> nodeFileList = nodeFileInfoTable.get(grpNode);
                    if (nodeFileList == null || "1".equals((nodeFileInfo = nodeFileList.get(file)).getStatus())) continue;
                    resultSet.addResult(grpNode, 3);
                    String errorMessage = s_gMsgBundle.getMessage("2028", false, (Object[])new String[]{nodeFileInfo.getFileName(), group});
                    ErrorDescription error = new ErrorDescription(errorMessage);
                    resultSet.addErrorDescription(error);
                    for (CollectionElement element : fileCollectionElementList) {
                        element.setStatus(3);
                        element.addErrorDescription(error);
                    }
                    nodeErrors = failedNodes.get(grpNode);
                    if (nodeErrors == null) {
                        nodeErrors = new ArrayList();
                    }
                    nodeErrors.add(errorMessage);
                    failedNodes.put(grpNode, nodeErrors);
                }
            }
        }
        if ((refPermissions == null || refPermissions != null && refPermissions.length() == 0) && consistPerms.keySet().size() > 1) {
            e = consistPerms.keys();
            while (e.hasMoreElements()) {
                String perm = (String)e.nextElement();
                List permNodes = (List)consistPerms.get(perm);
                for (String permNode : permNodes) {
                    Hashtable<String, FileInfo> nodeFileList = nodeFileInfoTable.get(permNode);
                    if (nodeFileList == null || "1".equals((nodeFileInfo = nodeFileList.get(file)).getStatus())) continue;
                    resultSet.addResult(permNode, 3);
                    String errorMessage = s_gMsgBundle.getMessage("2029", false, (Object[])new String[]{nodeFileInfo.getFileName(), perm});
                    ErrorDescription error = new ErrorDescription(errorMessage);
                    resultSet.addErrorDescription(error);
                    for (CollectionElement element : fileCollectionElementList) {
                        element.setStatus(3);
                        element.addErrorDescription(error);
                    }
                    nodeErrors = failedNodes.get(permNode);
                    if (nodeErrors == null) {
                        nodeErrors = new ArrayList();
                    }
                    nodeErrors.add(errorMessage);
                    failedNodes.put(permNode, nodeErrors);
                }
            }
        }
        return failedNodes;
    }

    private static void checkGetExectaskVerResults(ResultSet resultSet, ResultSet verResultSet, Collection<String> succNodes, Collection<String> failNodes, Collection<String> incompatibleNodes, boolean report) {
        Hashtable t = verResultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                String exectaskVersion = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("Exectask version on node '" + node + "' is '" + exectaskVersion + '\"'));
                if (VerificationUtil.compatibleExectask(exectaskVersion)) {
                    Trace.out((String)("Compatible exectask found on node: " + node));
                    succNodes.add(node);
                    continue;
                }
                Trace.out((String)("Incompatible exectask found on node: " + node));
                incompatibleNodes.add(node);
                continue;
            }
            failNodes.add(node);
            resultSet.addResult(node, 2);
            List<VerificationError> errors = result.getErrors();
            if (errors != null) {
                for (VerificationError error : errors) {
                    resultSet.addErrorDescription(node, (ErrorDescription)error);
                }
            }
            Trace.out((String)("Exectask version couldn't be fetched from node: " + node));
            if (report) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("7559", false, (Object[])new String[]{node}));
                if (errors != null) {
                    for (VerificationError error : errors) {
                        ReportUtil.printError(error.getErrorMessage());
                    }
                }
            }
            ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("7559", false, (Object[])new String[]{node}));
            resultSet.addErrorDescription(node, errDesc);
        }
    }

    public static boolean isUserEquivalence(String[] nodeList, Vector<String> succNodeVect, Vector<String> failNodeVect) {
        succNodeVect.clear();
        failNodeVect.clear();
        ResultSet userEquivResultSet = new ResultSet();
        boolean userEquivResult = new GlobalExecution().checkUserEquiv(nodeList, userEquivResultSet);
        Trace.out((String)"VerificationUtil::   checkUserEquiv() performed!!");
        Hashtable t = userEquivResultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                succNodeVect.add(node);
                Trace.out((String)("User Equivalence exists on on node: " + node));
                continue;
            }
            failNodeVect.add(node);
            Trace.out((String)("User Equivalence couldn't be performed on node: " + node));
        }
        return failNodeVect.size() == 0;
    }

    public static String[] getUserEquivalentNodes(String[] nodeList, ResultSet resultSet) {
        String[] validNodeArr = nodeList;
        Vector<String> failNodeVect = new Vector<String>();
        Vector<String> succNodeVect = new Vector<String>();
        validNodeArr = VerificationUtil.getReachableNodes(nodeList, resultSet, true);
        if (validNodeArr == null || validNodeArr.length == 0) {
            return null;
        }
        boolean userEquivOnAll = VerificationUtil.isUserEquivalence(validNodeArr, succNodeVect, failNodeVect);
        if (!userEquivOnAll) {
            if (succNodeVect.size() == 0) {
                ReportUtil.printError(s_msgBundle.getMessage("4008", true) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                if (resultSet != null) {
                    resultSet.addResult(validNodeArr, 2);
                    ErrorDescription errDesc = new ErrorDescription("4008", s_msgBundle);
                    resultSet.addErrorDescription(errDesc);
                    for (int i = 0; i < validNodeArr.length; ++i) {
                        String node = validNodeArr[i];
                        errDesc = new ErrorDescription(s_msgBundle.getMessage("4098", true, (Object[])new String[]{node}), s_msgBundle, "4098");
                        resultSet.addErrorDescription(node, errDesc);
                    }
                }
                return null;
            }
            if (failNodeVect.size() != 0) {
                ReportUtil.printWarning(s_msgBundle.getMessage("4009", false));
                ReportUtil.sureprintNodelist(failNodeVect);
                ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                ReportUtil.sureprintNodelist(succNodeVect);
                String[] invalidNodeArr = failNodeVect.toArray(new String[failNodeVect.size()]);
                if (resultSet != null) {
                    resultSet.addResult(invalidNodeArr, 2);
                    if (invalidNodeArr != null && invalidNodeArr.length != 0) {
                        resultSet.addResult(invalidNodeArr, 2);
                        for (int i = 0; i < invalidNodeArr.length; ++i) {
                            String node = invalidNodeArr[i];
                            ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("4098", false, (Object[])new String[]{node}));
                            resultSet.addErrorDescription(node, errDesc);
                        }
                    }
                }
                validNodeArr = succNodeVect.toArray(new String[succNodeVect.size()]);
            }
        }
        if (resultSet != null) {
            resultSet.addResult(validNodeArr, 1);
        }
        return validNodeArr;
    }

    public static String[] getUserEquivalentNodes(String[] nodeList) {
        return VerificationUtil.getUserEquivalentNodes(nodeList, null);
    }

    public static boolean isUserEquivalenceOnNode(String node, boolean displayErr) {
        boolean nodeReachable = false;
        Vector<String> errVect = new Vector<String>();
        nodeReachable = VerificationUtil.areNodesReachable(new String[]{node}, new Vector<String>(), new Vector<String>(), errVect);
        if (!nodeReachable) {
            if (displayErr) {
                ReportUtil.printError(s_msgBundle.getMessage("4097", false, (Object[])new String[]{node}) + LSEP + errVect.firstElement());
            }
            return false;
        }
        if (!VerificationUtil.isUserEquivalence(new String[]{node}, new Vector<String>(), new Vector<String>())) {
            if (displayErr) {
                ReportUtil.printError(s_msgBundle.getMessage("4098", false, (Object[])new String[]{node}));
            }
            return false;
        }
        return true;
    }

    public static boolean areNodesReachable(String[] nodeList, Vector<String> succNodeVect, Vector<String> failNodeVect, Vector<String> failNodeErrorVect) {
        succNodeVect.clear();
        failNodeVect.clear();
        failNodeErrorVect.clear();
        boolean[] nodeConArray = new boolean[nodeList.length];
        String[] nodeErrorArray = new String[nodeList.length];
        try {
            new VerifyNetwork().checkReachFromLocalNode(nodeList, nodeConArray, nodeErrorArray);
        }
        catch (NetworkException e) {
            Trace.out((String)("NetworkException " + e));
            failNodeErrorVect.add(e.getMessage());
            return false;
        }
        Trace.out((String)"VerificationUtil::   checkReachFromSrcNode() performed!!");
        for (int i = 0; i < nodeList.length; ++i) {
            String node = nodeList[i];
            if (nodeConArray[i]) {
                succNodeVect.add(node);
                Trace.out((String)("Node '" + node + "' is reachable"));
                continue;
            }
            failNodeVect.add(node);
            failNodeErrorVect.add(nodeErrorArray[i]);
            Trace.out((String)("Node '" + node + "' is not reachable"));
        }
        return failNodeVect.size() == 0;
    }

    public static String[] getReachableNodes(String[] nodeList, ResultSet resultSet) {
        return VerificationUtil.getReachableNodes(nodeList, resultSet, true);
    }

    public static String[] getReachableNodes(String[] nodeList, ResultSet resultSet, boolean bShowErr) {
        String[] validNodeArr = nodeList;
        Vector<String> failNodeVect = new Vector<String>();
        Vector<String> failNodeErrorVect = new Vector<String>();
        Vector<String> succNodeVect = new Vector<String>();
        boolean allReachable = false;
        allReachable = VerificationUtil.areNodesReachable(nodeList, succNodeVect, failNodeVect, failNodeErrorVect);
        if (!allReachable) {
            if (succNodeVect.size() == 0) {
                String displayError = VerificationUtil.strArr2String(failNodeErrorVect.toArray(new String[failNodeErrorVect.size()]), LSEP);
                if (bShowErr) {
                    ReportUtil.printError(displayError + LSEP + s_msgBundle.getMessage("0007", false));
                }
                if (resultSet != null) {
                    ErrorDescription errDesc = new ErrorDescription("4095", s_msgBundle);
                    resultSet.addErrorDescription(errDesc);
                    resultSet.addResult(nodeList, 2);
                    if (nodeList != null && nodeList.length != 0) {
                        for (int i = 0; i < nodeList.length; ++i) {
                            String node = nodeList[i];
                            errDesc = new ErrorDescription(s_msgBundle.getMessage("4097", false, (Object[])new String[]{node}) + LSEP + failNodeErrorVect.get(i));
                            resultSet.addErrorDescription(node, errDesc);
                        }
                    }
                }
                return null;
            }
            if (failNodeVect.size() != 0) {
                if (bShowErr) {
                    ReportUtil.sureprintln(VerificationUtil.strArr2String(failNodeErrorVect.toArray(new String[failNodeErrorVect.size()]), LSEP));
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                    ReportUtil.sureprintNodelist(succNodeVect);
                }
                validNodeArr = succNodeVect.toArray(new String[succNodeVect.size()]);
            }
        }
        if (resultSet != null) {
            resultSet.addResult(validNodeArr, 1);
            String[] invalidArr = failNodeVect.toArray(new String[failNodeVect.size()]);
            String[] invalidArrError = failNodeErrorVect.toArray(new String[failNodeVect.size()]);
            if (invalidArr != null && invalidArr.length != 0) {
                resultSet.addResult(invalidArr, 2);
                for (int i = 0; i < invalidArr.length; ++i) {
                    String node = invalidArr[i];
                    ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("4097", false, (Object[])new String[]{node}) + LSEP + invalidArrError[i], s_msgBundle, "4097");
                    resultSet.addErrorDescription(node, errDesc);
                }
            }
        }
        return validNodeArr;
    }

    public static String[] getReachableNodes(String[] nodeList) {
        return VerificationUtil.getReachableNodes(nodeList, null);
    }

    public static boolean isNodeReachable(String node) {
        Trace.out((String)("==== Checking rechability of node: " + node));
        String[] nodelist = new String[]{node};
        String[] noderslt = VerificationUtil.getReachableNodes(nodelist, null, false);
        return null != noderslt && noderslt.length != 0;
    }

    public static String[] getNodesWithCRSInstall(String[] nodeList, ResultSet resultSet) {
        return VerificationUtil.getNodesWithCRSInstall(nodeList, resultSet, false);
    }

    public static String[] getNodesWithCRSInstall(String[] nodeList, ResultSet resultSet, boolean mute) {
        String[] validNodeArr = nodeList;
        Vector<String> failNodeVect = new Vector<String>();
        Vector<String> succNodeVect = new Vector<String>();
        Trace.out((String)("nodeList='" + VerificationUtil.strArr2List(nodeList) + "'"));
        VerificationLogData.logFine(LSEP + "nodeList='" + VerificationUtil.strArr2List(nodeList) + "'");
        boolean crsInstallOnAll = VerificationUtil.isCRSInstalled(nodeList, succNodeVect, failNodeVect, mute);
        if (!crsInstallOnAll) {
            if (succNodeVect.size() == 0) {
                if (!mute) {
                    ReportUtil.printError(s_msgBundle.getMessage("4037", true) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                }
                if (resultSet != null) {
                    resultSet.addResult(nodeList, 2);
                    ErrorDescription errDesc = new ErrorDescription("4037", s_msgBundle);
                    resultSet.addErrorDescription(errDesc);
                    for (int i = 0; i < validNodeArr.length; ++i) {
                        String node = validNodeArr[i];
                        errDesc = new ErrorDescription("7593", new String[]{node}, s_msgBundle);
                        resultSet.addErrorDescription(node, errDesc);
                    }
                }
                return null;
            }
            if (failNodeVect.size() != 0) {
                if (!mute) {
                    ReportUtil.printWarning(s_msgBundle.getMessage("4038", true));
                    ReportUtil.sureprintNodelist(failNodeVect);
                    ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                    ReportUtil.sureprintNodelist(succNodeVect);
                }
                String[] invalidNodeArr = failNodeVect.toArray(new String[failNodeVect.size()]);
                if (resultSet != null) {
                    resultSet.addResult(invalidNodeArr, 2);
                    if (invalidNodeArr != null && invalidNodeArr.length != 0) {
                        resultSet.addResult(invalidNodeArr, 2);
                        for (int i = 0; i < invalidNodeArr.length; ++i) {
                            String node = invalidNodeArr[i];
                            ErrorDescription errDesc = new ErrorDescription("7593", new String[]{node}, s_msgBundle);
                            resultSet.addErrorDescription(node, errDesc);
                        }
                    }
                }
                validNodeArr = succNodeVect.toArray(new String[succNodeVect.size()]);
            }
        }
        if (resultSet != null) {
            resultSet.addResult(validNodeArr, 1);
            String[] invalidArr = VerificationUtil.diffStringArr(nodeList, validNodeArr);
            if (invalidArr != null && invalidArr.length != 0) {
                resultSet.addResult(invalidArr, 2);
            }
        }
        return validNodeArr;
    }

    public static String[] getNodesWithCRSInstall(String[] nodeList) {
        return VerificationUtil.getReachableNodes(nodeList, null);
    }

    public static String[] diffStringArr(String[] masterArr, String[] subArr) {
        Vector<String> resultVect = new Vector<String>();
        for (int i = 0; i < masterArr.length; ++i) {
            boolean toInclude = true;
            for (int j = 0; j < subArr.length; ++j) {
                if (!subArr[j].equals(masterArr[i])) continue;
                toInclude = false;
                break;
            }
            if (!toInclude) continue;
            resultVect.add(masterArr[i]);
        }
        return resultVect.toArray(new String[resultVect.size()]);
    }

    public static String getDaemonDisplayName(String daemonTag) {
        String daemonDispName;
        if (daemonTag.equalsIgnoreCase("crsd")) {
            daemonDispName = VDMUtil.getDaemonDisplayName("crsd");
            if (daemonDispName == null) {
                ReportUtil.printError(s_msgBundle.getMessage("9006", false) + LSEP);
            }
        } else if (daemonTag.equalsIgnoreCase("ocssd")) {
            daemonDispName = VDMUtil.getDaemonDisplayName("ocssd");
            if (daemonDispName == null) {
                ReportUtil.printError(s_msgBundle.getMessage("9007", false) + LSEP);
            }
        } else if (daemonTag.equalsIgnoreCase("evmd")) {
            daemonDispName = VDMUtil.getDaemonDisplayName("evmd");
            if (daemonDispName == null) {
                ReportUtil.printError(s_msgBundle.getMessage("9008", false) + LSEP);
            }
        } else {
            daemonDispName = daemonTag;
        }
        return daemonDispName;
    }

    public static String getDaemonInternalName(String daemonTag) {
        String daemonIntlName;
        if (daemonTag.equalsIgnoreCase("crsd")) {
            daemonIntlName = VDMUtil.getDaemonInternalName("crsd");
            if (daemonIntlName == null) {
                ReportUtil.printError(s_msgBundle.getMessage("9009", false) + LSEP);
            }
        } else if (daemonTag.equalsIgnoreCase("ocssd")) {
            daemonIntlName = VDMUtil.getDaemonInternalName("ocssd");
            if (daemonIntlName == null) {
                ReportUtil.printError(s_msgBundle.getMessage("9010", false) + LSEP);
            }
        } else if (daemonTag.equalsIgnoreCase("evmd")) {
            daemonIntlName = VDMUtil.getDaemonInternalName("evmd");
            if (daemonIntlName == null) {
                ReportUtil.printError(s_msgBundle.getMessage("9011", false) + LSEP);
            }
        } else {
            daemonIntlName = daemonTag;
        }
        return daemonIntlName;
    }

    public static MessageBundle getMessageBundle(String facility) {
        return MessageBundle.getMessageBundle((String)facility);
    }

    public static String getEnv(String envVar) {
        String value = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        NativeResult nativeRes = nativeSys.getEnvironment(envVar);
        value = nativeRes != null && nativeRes.getStatus() ? nativeRes.getStringResult() : null;
        if (Trace.isLevelEnabled((int)3)) {
            Trace.out((String)("==== getEnv reports: " + envVar + "=" + value));
        }
        return value;
    }

    public static String getEnv(String nodeName, String envVar) {
        if (VerificationUtil.isLocalNode(nodeName)) {
            return VerificationUtil.getEnv(envVar);
        }
        String value = null;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet envResultSet = new ResultSet();
        boolean res = globalExec.getSysParam(new String[]{nodeName}, envVar, envResultSet);
        Hashtable hostsTable = new Hashtable();
        Hashtable ht = envResultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                value = (String)result.getResultInfoSet().elementAt(0);
                Trace.out((String)("Retrieved value of an Environment Variable " + envVar + " from node: " + node + " The Value is :" + value));
                continue;
            }
            Trace.out((String)("Failed to retrieved value of an Environment Variable " + envVar + " from node: " + node));
        }
        return value;
    }

    public static String getUniqueDistributionID() {
        sVerificationUtil sUtil = new sVerificationUtil();
        String udid = sUtil.getUniqueDistributionID();
        if (udid == null || 0 == udid.trim().length()) {
            udid = VerificationUtil.getConfiguredValue(ASSUME_DISTID, true);
            if (udid == null) {
                udid = "unknown";
            }
            Trace.out((String)("==== Using default distribution ID: " + udid));
        }
        return udid;
    }

    public static String getOperatingSystemName() {
        return System.getProperty("os.name") + System.getProperty("os.version");
    }

    public static int compareVersions(String str1, String str2, String dlm) {
        VersionComparator versionComparator = new VersionComparator(dlm);
        return versionComparator.compare(str1, str2);
    }

    public static String getConfiguredValue(String var, boolean bFBToEnv) {
        ConfigUtil cu = ConfigUtil.getInstance();
        return cu.getConfiguredValue(var, bFBToEnv);
    }

    public static void getExecutionEnvironment() throws InvalidEnvironmentException {
        String destLoc = VerificationUtil.getDestLoc();
        if (!new File(destLoc).isAbsolute()) {
            throw new InvalidEnvironmentException(s_msgBundle.getMessage("9018", false, (Object[])new String[]{destLoc}));
        }
        VerificationUtil.setRDBMSVersion("12.1.0.1.0");
        Trace.out((String)("RDBMS Version is -->" + VerificationUtil.getRDBMSVersion()));
        try {
            String localHostName = VerificationUtil.getLocalHost();
            Trace.out((String)("localHostName is -->" + localHostName));
            VerificationUtil.setLocalHostName(localHostName);
        }
        catch (UnknownHostException e) {
            Trace.out((String)("UnknownHostException is thrown with this message: " + e.getMessage()));
            throw new InvalidEnvironmentException(s_msgBundle.getMessage("0002", true));
        }
        VerificationUtil.validateCmdLineExecEnvironment();
        sVerificationUtil.getExecutionEnvironment();
    }

    private static void validateCmdLineExecEnvironment() throws InvalidEnvironmentException {
        ParamManager pm;
        Trace.out((String)"Entered validateCmdLineExecEnvironment");
        MessageBundle theMB = MessageBundle.getMessageBundle((MessageBundleList.FacilityList)MessageBundleList.FacilityList.Prvg);
        try {
            pm = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException upme) {
            throw new InvalidEnvironmentException(upme.getMessage());
        }
        String cmdLineLS = pm.getCommandLineString();
        if (VerificationUtil.isHAConfigured() && cmdLineLS != null) {
            String[] nodelist;
            boolean cndnC;
            boolean cndnA = pm.checkArgStage();
            boolean cndnB = cmdLineLS.contains(CLSyntax.STR_DBINST);
            boolean bl = cndnC = cmdLineLS.contains(CLSyntax.STR_POST) && cmdLineLS.contains(CLSyntax.STR_CRSINST);
            if (cndnA && (cndnB || cndnC) && pm.hasArgument(Argument.ARG_NODELIST) && (nodelist = pm.getMultiPartArgVal(Argument.ARG_NODELIST)).length > 1) {
                throw new InvalidEnvironmentException(theMB.getMessage("5741", true));
            }
        }
        Trace.out((String)"Exit validateCmdLineExecEnvironment");
    }

    public static boolean compatibleExectask(String exectaskVersion) {
        Trace.out((String)("Comparing framework version '" + VerificationUtil.getFrameworkVersion() + "' with exectask version '" + exectaskVersion + "'"));
        return VerificationUtil.getFrameworkVersion().equals(exectaskVersion);
    }

    public static String getFrameworkVersion() {
        return VerificationUtil.getRDBMSVersion() + "." + "03_27_13_x86_64";
    }

    public static String getRDBMSVersion() {
        return s_RDBMSVersion;
    }

    public static void setRDBMSVersion(String rdbmsVer) {
        s_RDBMSVersion = rdbmsVer;
    }

    public static String getRequestedRelease() {
        String reqRel = null;
        try {
            ParamManager pm = ParamManager.getInstance();
            reqRel = pm.getSinglePartArgVal(Argument.ARG_RELEASE);
            if ("10gR1".equals(reqRel)) {
                reqRel = "10.1";
            } else if ("10gR2".equals(reqRel)) {
                reqRel = "10.2";
            } else if ("11gR1".equals(reqRel)) {
                reqRel = "11.1";
            } else if ("11gR2".equals(reqRel)) {
                reqRel = "11.2";
            }
            Trace.out((String)("==== Requested release is: " + reqRel));
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        return reqRel;
    }

    public static String getSIHAReleaseVersion() {
        return VerificationUtil.getSIHAReleaseVersion(false);
    }

    public static String getSIHAReleaseVersionWithException() throws NoSuchCRSHomeException, NoSuchExecutableException, ClusterInfoException, ConfigurationException, HAHomeNotFoundException {
        Version version = VerificationUtil.getSIHAReleaseVersionObjWithException();
        return version != null ? version.toString4() : null;
    }

    public static String getSIHAReleaseVersion(boolean ignoreException) {
        Version version = VerificationUtil.getSIHAReleaseVersionObj(ignoreException);
        return version != null ? version.toString4() : null;
    }

    public static Version getSIHAReleaseVersionObj() {
        return VerificationUtil.getSIHAReleaseVersionObj(false);
    }

    public static Version getSIHAReleaseVersionObj(String sihaHome, boolean ignoreException) {
        try {
            return VerificationUtil.getSIHAReleaseVersionObjWithException(sihaHome);
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)"Caught NoSuchCRSHomeException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)nche));
            }
            return null;
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)"Caught NoSuchExecutableException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)nsee));
            }
            return null;
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)"Caught ClusterInfoException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)cie));
            }
            return null;
        }
        catch (ConfigurationException ce) {
            Trace.out((String)("Configuration Exception: \n" + ce.getMessage()));
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)ce));
            }
            return null;
        }
    }

    public static Version getSIHAReleaseVersionObj(boolean ignoreException) {
        try {
            return VerificationUtil.getSIHAReleaseVersionObjWithException();
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)"Caught NoSuchCRSHomeException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)nche));
            }
            return null;
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)"Caught NoSuchExecutableException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)nsee));
            }
            return null;
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)"Caught ClusterInfoException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)cie));
            }
            return null;
        }
        catch (ConfigurationException ce) {
            Trace.out((String)("Configuration Exception: \n" + ce.getMessage()));
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)ce));
            }
            return null;
        }
        catch (HAHomeNotFoundException hae) {
            Trace.out((String)("HAHomeNotFoundException Exception: \n" + hae.getMessage()));
            if (!ignoreException) {
                VerificationUtil.reportException(hae);
            }
            return null;
        }
    }

    public static Version getSIHAReleaseVersionObjWithException() throws NoSuchCRSHomeException, NoSuchExecutableException, ClusterInfoException, ConfigurationException, HAHomeNotFoundException {
        String haHome;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if ((haHome = VerificationUtil.getHAHomeWithException()) == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ERROR: HA home undefined.");
            }
            return null;
        }
        return VerificationUtil.getSIHAReleaseVersionObjWithException(haHome);
    }

    public static Version getSIHAReleaseVersionObjWithException(String haHome) throws NoSuchCRSHomeException, NoSuchExecutableException, ClusterInfoException, ConfigurationException {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        String actVersion = null;
        Version activeVersion = null;
        ClusterInfo cluInfo = new ClusterInfo(haHome);
        actVersion = cluInfo.getSIHAReleaseVersionString();
        if (actVersion == null) {
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("HA version string obtained: '" + actVersion + "' "));
        }
        activeVersion = VerificationUtil.getVersionObject(actVersion);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nThe version object for HA on the local node is: " + activeVersion.toString()));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return activeVersion;
    }

    public static String getCRSActiveVersion() {
        return VerificationUtil.getCRSActiveVersion(false);
    }

    public static String getCRSActiveVersion(boolean ignoreException) {
        String crsHome;
        String activeVerStr = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if ((crsHome = VerificationUtil.getCRSHome(ignoreException)) == null || crsHome.trim().length() == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ERROR: CRS home undefined.");
            }
            return null;
        }
        try {
            activeVerStr = VerificationUtil.getCRSActiveVersionWithException();
            if (activeVerStr == null) {
                return null;
            }
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)"Caught NoSuchCRSHomeException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)nche));
            }
            return null;
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)"Caught NoSuchExecutableException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)nsee));
            }
            return null;
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)"Caught ClusterInfoException");
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)cie));
            }
            return null;
        }
        return activeVerStr;
    }

    public static String getCRSActiveVersionWithException() throws NoSuchCRSHomeException, NoSuchExecutableException, ClusterInfoException {
        String activeVerStr;
        block11: {
            String crsHome;
            activeVerStr = null;
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ENTRY");
            }
            if ((crsHome = VerificationUtil.getCRSHome()) == null || crsHome.trim().length() == 0) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"ERROR: CRS home undefined.");
                }
                return null;
            }
            ClusterInfo cluInfo = new ClusterInfo(crsHome);
            try {
                activeVerStr = cluInfo.getCRSActiveVersionString();
                if (activeVerStr != null) break block11;
                try {
                    String releaseVersion = VerificationUtil.getCRSReleaseVersion(VerificationUtil.getLocalHost());
                    if (releaseVersion != null) {
                        activeVerStr = releaseVersion;
                    }
                }
                catch (UnknownHostException e) {
                    Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
                }
            }
            catch (ClusterInfoException cie) {
                try {
                    String releaseVersion = VerificationUtil.getCRSReleaseVersion(VerificationUtil.getLocalHost());
                    if (releaseVersion == null) {
                        throw cie;
                    }
                    activeVerStr = releaseVersion;
                }
                catch (UnknownHostException e) {
                    Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
                }
            }
        }
        return activeVerStr;
    }

    public static Version getCRSActiveVersionObj() {
        return VerificationUtil.getCRSActiveVersionObj(false);
    }

    public static Version getCRSActiveVersionObj(boolean ignoreException) {
        Version activeVersion = null;
        String activeVerStr = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if ((activeVerStr = VerificationUtil.getCRSActiveVersion(ignoreException)) == null) {
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("CRS version string obtained: '" + activeVerStr + "' "));
        }
        try {
            activeVersion = VerificationUtil.getVersionObject(activeVerStr);
        }
        catch (ConfigurationException ce) {
            Trace.out((String)("Configuration Exception: \n" + ce.getMessage()));
            if (!ignoreException) {
                VerificationUtil.reportException((Exception)((Object)ce));
            }
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nThe version object for CRS on the local node is: " + String.valueOf(activeVersion)));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return activeVersion;
    }

    public static Version getVersionObject(String versionStr) throws ConfigurationException {
        Version version;
        block13: {
            version = new Version();
            String verStr = version.toString4();
            if (VerificationUtil.isVersionPost(versionStr, verStr)) {
                Trace.out((String)("Returning the maximum supported version " + verStr + " as the specified version " + versionStr + " " + "is found to be more recent than what we can instantiate"));
                return version;
            }
            version = null;
            try {
                version = Version.getVersion((String)versionStr);
            }
            catch (ConfigurationException e) {
                if (versionStr != null) break block13;
                throw e;
            }
        }
        if (version == null) {
            if (versionStr.startsWith("10.1")) {
                version = Version.get101Version();
            } else if (versionStr.startsWith("10.2")) {
                version = Version.get102Version();
            } else if (versionStr.startsWith("11.1")) {
                version = Version.get111Version();
            } else if (versionStr.startsWith("11.2")) {
                version = Version.get11201Version();
            } else if (versionStr.startsWith("12.1")) {
                version = Version.get12100Version();
            }
        }
        return version;
    }

    public static String getCRSSoftwareVersion(String hostname) {
        Object softVersion = null;
        String node = VerificationUtil.getNodeName(hostname);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        String crsHome = VerificationUtil.getCRSHome();
        return VerificationUtil.getCRSSoftwareVersion(crsHome, node);
    }

    public static String getCRSSoftwareVersion(String crsHome, String hostname) {
        String softVersion = null;
        if (crsHome == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ERROR: CRS home undefined.");
            }
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("crsHome=" + crsHome));
        }
        try {
            ClusterInfo cluInfo = new ClusterInfo(crsHome);
            softVersion = cluInfo.getCRSSoftwareVersionString(hostname);
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)"Caught NoSuchCRSHomeException");
            VerificationUtil.reportException((Exception)((Object)nche));
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)"Caught NoSuchExecutableException");
            VerificationUtil.reportException((Exception)((Object)nsee));
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)"Caught ClusterInfoException");
            VerificationUtil.reportException((Exception)((Object)cie));
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nThe software version for CRS on node '" + hostname + "' is: " + softVersion));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return softVersion;
    }

    public static String getCRSReleaseVersion(String crsHome, boolean reportException) {
        String version = null;
        try {
            String localHost = VerificationUtil.getLocalHost();
            version = VerificationUtil.getCRSReleaseVersion(crsHome, localHost);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return version;
    }

    public static String getCRSReleaseVersion(String hostname) {
        Result rslt;
        String crsHome;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if ((crsHome = VerificationUtil.getCRSHome(hostname, rslt = new Result(hostname))) == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ERROR: CRS home undefined.");
            }
            return null;
        }
        return VerificationUtil.getCRSReleaseVersion(crsHome, hostname);
    }

    public static String getCRSReleaseVersion(String crsHome, String hostname) {
        return VerificationUtil.getCRSReleaseVersion(crsHome, hostname, true);
    }

    public static String getCRSReleaseVersion(String crsHome, String hostname, boolean useChache) {
        String version = null;
        String key = crsHome + "@" + hostname;
        if (useChache && (version = s_releaseVersionMap.get(key)) != null) {
            Trace.out((String)("Returning version: " + version + " from cache. key used is " + key));
            return version;
        }
        Result crsctlRslt = new Result(hostname);
        version = VerificationUtil.getCRSReleaseVersionUsingCRSCTL(crsHome, hostname, crsctlRslt);
        Trace.out((int)5, (String)"release version using crsctl=%s", (Object[])new Object[]{version});
        if (VerificationUtil.isStringGood(version)) {
            s_releaseVersionMap.put(key, version);
            VerificationLogData.logInfo("CRSReleaseVersion: " + version);
            return version;
        }
        Result ocrDumpRslt = new Result(hostname);
        version = VerificationUtil.getCRSReleaseVersionUsingOCRDump(crsHome, hostname, ocrDumpRslt);
        Trace.out((int)5, (String)"release version using ocrdump=%s", (Object[])new Object[]{version});
        if (VerificationUtil.isStringGood(version)) {
            s_releaseVersionMap.put(key, version);
            VerificationLogData.logInfo("CRSReleaseVersion: " + version);
            return version;
        }
        Result srvctlRslt = new Result(hostname);
        version = VerificationUtil.getCRSReleaseVersionUsingSRVCTL(crsHome, hostname, srvctlRslt);
        Trace.out((int)5, (String)"release version using srvctl=%s", (Object[])new Object[]{version});
        if (!VerificationUtil.isStringGood(version)) {
            String activeCRSVersion = null;
            try {
                activeCRSVersion = new ClusterInfo(crsHome).getCRSActiveVersionString();
            }
            catch (NoSuchCRSHomeException e) {
                Trace.out((String)("IGNORED: " + ((Object)((Object)e)).getClass() + ": " + e.getMessage()));
            }
            catch (NoSuchExecutableException e) {
                Trace.out((String)("IGNORED: " + ((Object)((Object)e)).getClass() + ": " + e.getMessage()));
            }
            catch (ClusterInfoException e) {
                Trace.out((String)("IGNORED: " + ((Object)((Object)e)).getClass() + ": " + e.getMessage()));
            }
            if (activeCRSVersion != null && VerificationUtil.isVersionPre(activeCRSVersion, "10.2") && VerificationUtil.isVersionPost(activeCRSVersion, "10")) {
                version = Version.get101Version().toString();
                Trace.out((int)5, (String)"active version is %s, defaulting release version to %s", (Object[])new Object[]{activeCRSVersion, version});
            }
        }
        s_releaseVersionMap.put(key, version);
        VerificationLogData.logInfo("CRSReleaseVersion: " + version);
        return version;
    }

    public static String getCRSReleaseVersionUsingCRSCTL(String crsHome, String hostname, Result rslt) {
        String releaseVersion = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String cmd = crsHome + File.separator + "bin" + File.separator + nativeSystem.getExeName("crsctl");
        String[] cmdArg = new String[3];
        String RELEASE_VERSION = "releaseversion";
        cmdArg[0] = "query";
        cmdArg[1] = "crs";
        cmdArg[2] = "releaseversion";
        NativeResult result = new NativeResult();
        if (nativeSystem.isRemoteExecServerNeeded()) {
            try {
                nativeSystem.startRemoteExecServer(crsHome, crsHome);
            }
            catch (NativeException e) {
                Trace.out((String)"nativeSystem.startRemoteExecServer failed");
                rslt.addErrorDescription(new ErrorDescription(e.getMessage()));
                rslt.setStatus(2);
                return null;
            }
        }
        nativeSystem.runRemoteExecCmd(cmd, cmdArg, new String[]{"NLS_LANG="}, hostname, result);
        if (result.getStatus()) {
            String[] res = result.getResultString();
            if (res != null & res.length > 0) {
                String output = VerificationUtil.strArr2List(res, "").trim();
                releaseVersion = output;
                if (releaseVersion.indexOf("]") >= 0) {
                    StringTokenizer st = new StringTokenizer(output, "[", false);
                    st.nextToken();
                    releaseVersion = st.hasMoreTokens() ? st.nextToken() : null;
                    int index = releaseVersion.indexOf("]");
                    if (index != -1) {
                        rslt.setStatus(1);
                        releaseVersion = releaseVersion.substring(0, index);
                    } else {
                        rslt.setStatus(2);
                        releaseVersion = null;
                    }
                } else if (releaseVersion.indexOf("releaseversion") > 0) {
                    releaseVersion = null;
                }
                Trace.out((String)("Release version = " + releaseVersion));
            } else {
                rslt.setStatus(2);
                Trace.out((String)"runCmd failed to return successful status");
            }
        } else {
            rslt.setStatus(2);
            Trace.out((String)"runCmd failed to return successful status");
        }
        return releaseVersion;
    }

    public static String getCRSReleaseVersionUsingSRVCTL(String crsHome, String hostname, Result result) {
        Version version;
        ArrayList<VerificationError> errors = new ArrayList<VerificationError>();
        int status = 5;
        try {
            version = new ClusterwareInfo().getSRVCTLVersion(hostname, crsHome);
            if (version != null) {
                result.setStatus(1);
                return version.toString();
            }
        }
        catch (InstallException e) {
            Trace.out((int)5, (String)"Exception  %s: %s", (Object[])new Object[]{((Object)((Object)e)).getClass(), e.getMessage()});
            VerificationLogData.logError(((Object)((Object)e)).getClass() + ": " + e.getMessage() + LSEP + Trace.getStackTrace((Throwable)e));
            errors.add(new ErrorDescription(e.getMessage()));
            status = 2;
        }
        try {
            version = new ClusterwareInfo().getSRVCTLVersionNLS(hostname, crsHome);
            if (version != null) {
                result.setStatus(1);
                return version.toString();
            }
        }
        catch (InstallException e) {
            Trace.out((int)5, (String)"Exception  %s: %s", (Object[])new Object[]{((Object)((Object)e)).getClass(), e.getMessage()});
            VerificationLogData.logError(((Object)((Object)e)).getClass() + ": " + e.getMessage() + LSEP + Trace.getStackTrace((Throwable)e));
            errors.add(new ErrorDescription(e.getMessage()));
            status = 2;
        }
        result.setStatus(status);
        result.addErrorDescription(errors);
        return null;
    }

    public static String getCRSReleaseVersionUsingOCRDump(String crsHome, String node, Result result) {
        Matcher m;
        Pattern p;
        String[] lineByLine;
        String nodeNumber = null;
        String releaseVersion = null;
        try {
            nodeNumber = new ClusterInfo(crsHome).getNodeNumber(node);
            Trace.out((int)5, (String)"Node name=%s, node number retrieved from olsnodes=%s", (Object[])new Object[]{node, nodeNumber});
        }
        catch (NoSuchCRSHomeException e) {
            Trace.out((int)5, (String)e.getMessage());
            result.addErrorDescription(new ErrorDescription(e.getMessage()));
            result.setStatus(2);
            return null;
        }
        catch (NoSuchExecutableException e) {
            Trace.out((int)5, (String)e.getMessage());
            result.addErrorDescription(new ErrorDescription(e.getMessage()));
            result.setStatus(2);
            return null;
        }
        catch (ClusterInfoException e) {
            Trace.out((int)5, (String)e.getMessage());
            result.addErrorDescription(new ErrorDescription(e.getMessage()));
            result.setStatus(2);
            return null;
        }
        String nodeVersionKey = "SYSTEM.version.node_numbers.node" + nodeNumber;
        StringBuffer ocrKeyValue = VerificationUtil.getKeyValueFromOCRDump(crsHome, nodeVersionKey, result);
        if (ocrKeyValue != null && ocrKeyValue.length() > 0 && result.getStatus() == 1) {
            lineByLine = VerificationUtil.string2strArr(ocrKeyValue.toString(), LINE_SEPARATOR);
            p = Pattern.compile("(\\s*)ORATEXT([^:]*):(\\s*)(.*)");
            for (String outputLine : lineByLine) {
                m = p.matcher(outputLine);
                if (!m.matches()) continue;
                releaseVersion = m.group(4);
                break;
            }
        }
        if (!VerificationUtil.isStringGood(releaseVersion) && (ocrKeyValue = VerificationUtil.getKeyValueFromOCRDump(crsHome, nodeVersionKey = "SYSTEM.version.hostnames." + node, result)) != null && ocrKeyValue.length() > 0 && result.getStatus() == 1) {
            lineByLine = VerificationUtil.string2strArr(ocrKeyValue.toString(), LINE_SEPARATOR);
            p = Pattern.compile("(\\s*)ORATEXT([^:]*):(\\s*)(.*)");
            for (String outputLine : lineByLine) {
                m = p.matcher(outputLine);
                if (!m.matches()) continue;
                releaseVersion = m.group(4);
                break;
            }
        }
        if (!VerificationUtil.isStringGood(releaseVersion)) {
            Trace.out((String)"Failed to retrieve the CRS version using OCRDUMP");
            result.setStatus(3);
            return null;
        }
        Trace.out((int)5, (String)("The CRS release version retrieved using OCR dump is " + releaseVersion));
        result.setStatus(1);
        return releaseVersion;
    }

    public static Version getCRSSoftwareVersionObj() {
        String crsHome;
        Version softVersion = null;
        String softVerStr = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if ((crsHome = VerificationUtil.getCRSHome()) == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ERROR: CRS home undefined.");
            }
            return null;
        }
        try {
            ClusterInfo cluInfo = new ClusterInfo(crsHome);
            softVerStr = cluInfo.getCRSSoftwareVersionString();
            if (softVerStr == null) {
                return null;
            }
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out((String)"Caught NoSuchCRSHomeException");
            VerificationUtil.reportException((Exception)((Object)nche));
            return null;
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out((String)"Caught NoSuchExecutableException");
            VerificationUtil.reportException((Exception)((Object)nsee));
            return null;
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)"Caught ClusterInfoException");
            VerificationUtil.reportException((Exception)((Object)cie));
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("CRS version string obtained: '" + softVerStr + "' "));
        }
        try {
            softVersion = VerificationUtil.getVersionObject(softVerStr);
        }
        catch (ConfigurationException ce) {
            Trace.out((String)("Configuration Exception: \n" + ce.getMessage()));
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nThe version object for CRS on the local node is: " + String.valueOf(softVersion)));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return softVersion;
    }

    public static void setLocalNodeOperation(boolean isLocalNodeOper) {
        m_isLocalNodeOper = isLocalNodeOper;
        m_isLocalNodeOperationChecked = true;
        m_isLocal = isLocalNodeOper;
    }

    public static boolean isLocalNodeOperation() {
        String[] nodelist;
        boolean localNode;
        ParamManager pm;
        block23: {
            pm = null;
            localNode = false;
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ENTRY");
            }
            try {
                pm = ParamManager.getInstance();
                if (pm.getMode() == ParamManager.OperationMode.MODE_API) {
                    return m_isLocalNodeOper;
                }
            }
            catch (UninitializedParamManagerException e) {
                Trace.out((Exception)e);
                return false;
            }
            if (m_isLocalNodeOperationChecked) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Returning saved value of: " + m_isLocal));
                }
                return m_isLocal;
            }
            m_isLocalNodeOperationChecked = true;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"nodelistArg not NULL");
            }
            try {
                nodelist = VerificationUtil.getNodelist();
            }
            catch (NodelistNotFoundException nlnfe) {
                nodelist = new String[]{};
            }
            if (nodelist.length == 1) {
                String localhost = null;
                try {
                    localhost = Utils.getLocalHost();
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nComparing localhost '" + localhost + "' with nodelist[0] '" + nodelist[0] + "'\n"));
                    }
                    if (nodelist[0].equalsIgnoreCase(localhost) || VerificationUtil.sameHost(nodelist[0], localhost)) {
                        localNode = true;
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("Nodelist equal to localhost: " + localhost));
                        }
                    } else {
                        ClusterInfo cInfo;
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)"Nodelist not equal to localhost");
                        }
                        if (localhost.equalsIgnoreCase((cInfo = new ClusterInfo(VerificationUtil.getCRSHome())).getHostName(nodelist[0]))) {
                            localNode = true;
                            if (Trace.isLevelEnabled((int)5)) {
                                Trace.out((String)"localhost equal to cluster info host name.");
                            }
                        }
                    }
                }
                catch (UnknownHostException uhe) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)"UnknownHostException caught");
                    }
                }
                catch (ClusterInfoException cie) {
                    if (!Trace.isLevelEnabled((int)5)) break block23;
                    Trace.out((String)"ClusterInfoException caught");
                }
            }
        }
        Argument referenceNodeArg = pm.getArgument(Argument.ARG_REFNODE);
        Argument sourceNodeArg = pm.getArgument(Argument.ARG_SRCNODE);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nnodelist is: '" + VerificationUtil.strArr2List(nodelist) + "'" + "\nreferenceNodeArg is: '" + referenceNodeArg + "'" + "\nsourceNodeArg is: '" + sourceNodeArg + "'" + "\nlocalNode is: '" + localNode + "'"));
        }
        boolean bl = m_isLocal = localNode && referenceNodeArg == null && sourceNodeArg == null;
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("m_isLocal is: '" + m_isLocal + "'"));
        }
        return m_isLocal;
    }

    public static boolean isLocalNode(String node) {
        block18: {
            String localNode;
            String localHost;
            String nodeName;
            block17: {
                int dotIdx;
                nodeName = null;
                localHost = null;
                localNode = null;
                if (Trace.isLevelEnabled((int)2)) {
                    Trace.out((String)"ENTRY");
                }
                nodeName = (dotIdx = node.indexOf(".")) != -1 ? node.substring(0, dotIdx) : node;
                try {
                    localHost = VerificationUtil.getLocalHost();
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nComparing '" + nodeName + "' to localHOST '" + localHost + "'"));
                    }
                    if (nodeName.equalsIgnoreCase(localHost)) {
                        if (Trace.isLevelEnabled((int)2)) {
                            Trace.out((String)"EXIT - returning: true");
                        }
                        return true;
                    }
                }
                catch (UnknownHostException uhe) {
                    if (!Trace.isLevelEnabled((int)5)) break block17;
                    Trace.out((String)"UnknownHostException caught");
                }
            }
            if (VerificationUtil.sameHost(nodeName, localHost)) {
                return true;
            }
            try {
                if (!new ClusterwareInfo().isCRSConfigured()) break block18;
                try {
                    localNode = VerificationUtil.getLocalNodename();
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nComparing '" + nodeName + "' to localNODE '" + localNode + "'"));
                    }
                    if (nodeName.equalsIgnoreCase(localNode)) {
                        if (Trace.isLevelEnabled((int)2)) {
                            Trace.out((String)"EXIT - returning: true");
                        }
                        return true;
                    }
                }
                catch (NodelistNotFoundException nlnfe) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)"NodelistNotFoundException caught");
                    }
                }
            }
            catch (InstallException e) {
                if (!Trace.isLevelEnabled((int)5)) break block18;
                Trace.out((String)("InstallException caught: " + (Object)((Object)e)));
            }
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Returning: false");
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return false;
    }

    public static boolean sameHost(String host1, String host2) {
        InetAddress[] inetArr1 = null;
        InetAddress[] inetArr2 = null;
        try {
            inetArr1 = InetAddress.getAllByName(host1);
            inetArr2 = InetAddress.getAllByName(host2);
        }
        catch (UnknownHostException e) {
            return false;
        }
        for (int i = 0; i < inetArr1.length; ++i) {
            for (int j = 0; j < inetArr2.length; ++j) {
                if (!inetArr1[i].getHostAddress().equals(inetArr2[j].getHostAddress())) continue;
                return true;
            }
        }
        Trace.out((String)("VerificationUtil::sameHost() Host:" + host1 + " and Host: " + host2 + " are not same."));
        return false;
    }

    public static boolean evaluateCondition(String condition) {
        boolean conditionValue = false;
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Evaluating the condition '" + condition + "'"));
        }
        if (s_conditionValueRepos.containsKey(condition)) {
            conditionValue = s_conditionValueRepos.get(condition);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"The condition value was set. condition = %s, value = %b", (Object[])new Object[]{condition, conditionValue});
            }
        } else {
            if (CRS_HOME_REQ.equals(condition)) {
                try {
                    return new ClusterwareInfo().isCRSConfigured();
                }
                catch (InstallException e) {
                    Trace.out((String)("IGNORED: " + ((Object)((Object)e)).getClass() + ": " + e.getMessage()));
                    return false;
                }
            }
            if (HA_HOME_REQ.equals(condition)) {
                try {
                    return new ClusterwareInfo().isHAConfigured();
                }
                catch (InstallException e) {
                    Trace.out((String)(((Object)((Object)e)).getClass() + ": " + e.getMessage()));
                    return false;
                }
            }
            if (condition != null && condition.startsWith("PROCESSOR.")) {
                String arch = condition.substring("PROCESSOR.".length());
                String archRegEx = arch.replaceAll("x", ".*");
                archRegEx = archRegEx.replaceAll("X", ".*");
                String osarch = sVerificationUtil.getCurrentArch();
                return Pattern.compile(archRegEx, 2).matcher(osarch).matches();
            }
            if (condition != null && condition.startsWith("OSRELEASE_")) {
                String kRel = sVerificationUtil.getKernelRelease();
                String toMatch = VerificationUtil.getVersionFromCndnString(condition);
                return kRel.startsWith(toMatch);
            }
            if ("ASM_RUNNING".equals(condition)) {
                try {
                    String localHost = VerificationUtil.getLocalHost();
                    ArrayList<String> runningNodeList = new ArrayList<String>();
                    ArrayList<String> notRunningNodeList = new ArrayList<String>();
                    new ASMDiskGroupsUtil().checkASMRunning(new String[]{localHost}, runningNodeList, notRunningNodeList);
                    return runningNodeList.size() > 0;
                }
                catch (UnknownHostException e) {
                    Trace.out((String)(e.getClass() + ": " + e.getMessage()));
                    return false;
                }
                catch (ASMDiskGroupsUtilException e) {
                    Trace.out((String)(e.getClass() + ": " + e.getMessage()));
                    return false;
                }
            }
            conditionValue = sVerificationUtil.evaluateCondition(condition);
        }
        Trace.out((String)("evaluating condtion: CONDITION = " + condition + " VALUE=" + conditionValue));
        return conditionValue;
    }

    private static String getVersionFromCndnString(String condition) {
        return condition.substring(condition.indexOf(condition.split("_")[2]));
    }

    public static void setConditionValue(String condition, boolean value) {
        Trace.out((String)("setting condtion: CONDITION = " + condition + " VALUE=" + value));
        VerificationLogData.logInfo("CONDITION: " + condition + " VALUE:" + value);
        s_conditionValueRepos.put(condition, value);
    }

    public static void clearConditionValue(String condition) {
        Trace.out((String)("clearing condition: VAR = " + condition));
        VerificationLogData.logInfo("CONDITION: " + condition);
        s_conditionValueRepos.remove(condition);
    }

    public static String getPreReqXmlPath(VerificationType vfyType) throws XmlFilePathException {
        String reqRel = VerificationUtil.getRequestedRelease();
        if ("10gR1".equalsIgnoreCase(reqRel)) {
            reqRel = "10.1";
        } else if ("10gR2".equalsIgnoreCase(reqRel)) {
            reqRel = "10.2";
        } else if ("11gR1".equalsIgnoreCase(reqRel)) {
            reqRel = "11.1";
        } else if ("11gR2".equalsIgnoreCase(reqRel)) {
            reqRel = "11.2";
        }
        if (reqRel == null) {
            reqRel = "12.1";
        }
        return VerificationUtil.getPreReqXmlPath(vfyType, reqRel);
    }

    public static String getPreReqXmlPath(VerificationType vfyType, String reqRel) throws XmlFilePathException {
        File filePath;
        String xmlFilePath = s_preReqXmlRepos.get((Object)vfyType);
        if (xmlFilePath == null) {
            xmlFilePath = s_genericPreReqXmlFile;
            if (xmlFilePath == null) {
                xmlFilePath = sVerificationUtil.getPreReqXmlPath();
            }
            String xmlDirPath = null;
            if (xmlFilePath == null) {
                xmlDirPath = VerificationUtil.getPreReqDirPath(reqRel);
                xmlFilePath = CVUAutoUpdateManager.getCVUFileLocation(xmlDirPath + VerificationUtil.getPreReqXmlFileName(vfyType));
            }
        }
        if (!(filePath = new File(xmlFilePath)).exists()) {
            throw new XmlFilePathException(xmlFilePath + " does not exist.");
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Pre-req xml file is: '" + xmlFilePath + "'"));
        }
        return xmlFilePath;
    }

    public static String getPreReqDirPath(String release) {
        int secondDot;
        int firstDot;
        String xmlDirPath = null;
        if (release == null) {
            release = "12.1";
        }
        if ((firstDot = release.indexOf(46)) != -1 && (secondDot = release.indexOf(46, firstDot + 1)) != -1) {
            release = release.substring(0, secondDot);
        }
        String releaseDir = release.replace(".", "");
        xmlDirPath = "cv" + FILE_SEPARATOR + "cvdata" + FILE_SEPARATOR + releaseDir + FILE_SEPARATOR;
        return xmlDirPath;
    }

    public static String getPreReqXmlFileName(VerificationType vfyType) {
        String preReqXmlFileName = null;
        switch (vfyType) {
            case PREREQ_CRS_INST: 
            case SYSREQ_CRS: 
            case PREREQ_NODE_ADD: {
                preReqXmlFileName = CV_CRS_PREREQ_XML;
                break;
            }
            case PREREQ_DB_INST: 
            case PREREQ_DB_CONFIG: 
            case PREREQ_SI_DB_INST: 
            case PREREQ_SI_DB_CONFIG: 
            case SYSREQ_DB: 
            case SYSREQ_SI_DB: {
                preReqXmlFileName = CV_DB_PREREQ_XML;
                break;
            }
            case PREREQ_SI_HA_INST: 
            case PREREQ_SI_HA_CONFIG: 
            case SYSREQ_SI_HA: {
                preReqXmlFileName = CV_HA_PREREQ_XML;
            }
        }
        return preReqXmlFileName;
    }

    public static String getPreReqXmlSchemaURI(String release) throws XmlFilePathException {
        String fsep = File.separator;
        String fullpath = new File(CVUAutoUpdateManager.getCVUFileLocation("cv" + fsep + "cvdata" + fsep + "prereq.xsd")).toURI().toString();
        Trace.out((String)("==== Pre-req schema file: " + fullpath));
        return fullpath;
    }

    public static String getPluggableTaskXmlSchemaURI() throws XmlFilePathException {
        String fsep = File.separator;
        String fullpath = new File(CVUAutoUpdateManager.getCVUFileLocation("cv" + fsep + "cvdata" + fsep + "pluggable.xsd")).toURI().toString();
        Trace.out((String)("==== Pluggable task schema file: " + fullpath));
        return fullpath;
    }

    public static String getPluggableTaskXmlURI() throws XmlFilePathException {
        String fsep = FILE_SEPARATOR;
        String fullpath = new File(CVUAutoUpdateManager.getCVUFileLocation("cv" + fsep + "cvdata" + fsep + "pluggable.xml")).toURI().toString();
        Trace.out((String)("==== Pluggable task schema file: " + fullpath));
        return fullpath;
    }

    public static String getPluggableTaskDarwinXmlURI() throws XmlFilePathException {
        String fsep = FILE_SEPARATOR;
        String fullpath = new File(CVUAutoUpdateManager.getCVUFileLocation("cv" + fsep + "cvdata" + fsep + "darwin_pluggable.xml")).toURI().toString();
        Trace.out((String)("==== Pluggable task schema file: " + fullpath));
        return fullpath;
    }

    public static boolean isPreReqSupported() throws VerificationException {
        String prereqFile = s_genericPreReqXmlFile;
        return VerificationUtil.isPreReqSupported(prereqFile);
    }

    public static boolean isPreReqSupported(VerificationType vfyType) throws VerificationException {
        try {
            String prereqFile = VerificationUtil.getPreReqXmlPath(vfyType);
            return VerificationUtil.isPreReqSupported(prereqFile);
        }
        catch (XmlFilePathException e) {
            throw new VerificationException(e);
        }
    }

    private static boolean isPreReqSupported(String prereqFile) throws VerificationException, PreReqNotSupportedException {
        try {
            XmlTaskFactory xmlTaskFactory = XmlTaskFactory.getInstance();
            xmlTaskFactory.getTasks(prereqFile, VerificationUtil.getUniqueDistributionID(), new String[]{VerificationUtil.getLocalHost()});
            return true;
        }
        catch (UnknownHostException e) {
            throw new VerificationException(e);
        }
        catch (XmlParserException e) {
            throw new VerificationException(e);
        }
    }

    public static String getCompSoftwareConfigXmlPath() throws XmlFilePathException {
        return VerificationUtil.getCompSoftwareConfigXmlPath("12.1");
    }

    public static String getCompSoftwareConfigXmlPath(String release) throws XmlFilePathException {
        if (release == null) {
            release = "12.1";
        }
        String releaseDir = release.replace(".", "");
        String fullpath = CVUAutoUpdateManager.getCVUFileLocation("cv" + FILE_SEPARATOR + "cvdata" + FILE_SEPARATOR + releaseDir + FILE_SEPARATOR + "ora_software_cfg.xml");
        Trace.out((String)("==== Software Config data file: " + fullpath));
        return fullpath;
    }

    public static String getCompSoftwareConfigXmlPath(String home, String release) throws XmlFilePathException {
        return home + "/cv/cvdata/" + "ora_software_cfg.xml";
    }

    public static String getOSVersionCompatXmlPath() throws XmlFilePathException {
        String xmlFilePath = sVerificationUtil.getOSVersionCompatXmlPath();
        return xmlFilePath;
    }

    private static String resolveVariable(String name) {
        String value = null;
        if (s_variableValueRepos.containsKey(name)) {
            value = s_variableValueRepos.get(name);
            Trace.out((String)("pre-req variable found in the repository.var name=" + name + " value=" + value));
        } else if ("CRS_HOME".equalsIgnoreCase(name)) {
            value = VerificationUtil.getCRSHome();
        } else if ("SIHA_HOME".equalsIgnoreCase(name)) {
            value = VerificationUtil.getHAHome();
        } else if ("GRID_SOFTWARE_VERSION".equalsIgnoreCase(name)) {
            value = VerificationUtil.isCRSConfigured() ? String.valueOf(VerificationUtil.getCRSSoftwareVersionObj()) : String.valueOf(VerificationUtil.getSIHAReleaseVersion(true));
        } else if ("GRID_RELEASE_VERSION".equalsIgnoreCase(name)) {
            if (VerificationUtil.isCRSConfigured()) {
                try {
                    String localHost = VerificationUtil.getLocalHost();
                    value = VerificationUtil.getCRSReleaseVersion(localHost);
                }
                catch (UnknownHostException e) {}
            } else {
                value = String.valueOf(VerificationUtil.getSIHAReleaseVersion(true));
            }
        } else if ("GRID_ACTIVE_VERSION".equalsIgnoreCase(name)) {
            value = VerificationUtil.getCRSActiveVersion(true);
        } else if ("SRC_HOME_RELEASE_VERSION".equalsIgnoreCase(name)) {
            String crsHome = VerificationUtil.getVariableValue("oracle_install_crs_configuredCRSHome");
            if (VerificationUtil.isCRSConfigured()) {
                try {
                    String localHost = VerificationUtil.getLocalHost();
                    value = VerificationUtil.getCRSReleaseVersion(crsHome, localHost);
                }
                catch (UnknownHostException e) {}
            } else {
                value = String.valueOf(VerificationUtil.getSIHAReleaseVersion(true));
            }
        } else if ("DEST_HOME_RELEASE_VERSION".equalsIgnoreCase(name)) {
            String crsHome = VerificationUtil.getVariableValue("CRS_HOME");
            if (VerificationUtil.isCRSConfigured()) {
                try {
                    String localHost = VerificationUtil.getLocalHost();
                    value = VerificationUtil.getCRSReleaseVersion(crsHome, localHost);
                }
                catch (UnknownHostException e) {}
            } else {
                value = String.valueOf(VerificationUtil.getSIHAReleaseVersion(true));
            }
        } else if ("SRC_RAC_HOME_VERSION".equalsIgnoreCase(name)) {
            String oracleHome = VerificationUtil.getVariableValue("SRC_RAC_HOME");
            try {
                Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
                if (crsActiveVersion != null) {
                    value = String.valueOf(new DBUtils(crsActiveVersion).getDBVersion(oracleHome));
                }
            }
            catch (DBUtilsException e) {
                Trace.out((int)5, (String)"Following exception ignored while determing the version of oracle home %s as part of evaluating variable %s", (Object[])new Object[]{oracleHome, "SRC_RAC_HOME_VERSION"});
                Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
            }
        } else if ("DEST_RAC_HOME_VERSION".equalsIgnoreCase(name)) {
            String oracleHome = VerificationUtil.getVariableValue("RAC_HOME");
            try {
                Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
                if (crsActiveVersion != null) {
                    value = String.valueOf(new DBUtils(crsActiveVersion).getDBVersion(oracleHome));
                }
            }
            catch (DBUtilsException e) {
                Trace.out((int)5, (String)"Following exception ignored while determing the version of oracle home %s as part of evaluating variable %s", (Object[])new Object[]{oracleHome, "DEST_RAC_HOME_VERSION"});
                Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
            }
        } else if ("RAC_VERSION".equalsIgnoreCase(name)) {
            String racHome = VerificationUtil.getVariableValue("CV_RAC_HOME");
            try {
                Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
                if (crsActiveVersion != null) {
                    value = String.valueOf(new DBUtils(crsActiveVersion).getDBVersion(racHome));
                }
            }
            catch (DBUtilsException e) {
                Trace.out((int)5, (String)"Following exception ignored while determing the version of RAC home %s as part of evaluating variable %s", (Object[])new Object[]{racHome, "RAC_VERSION"});
                Trace.out((String)(e.getClass() + ": " + e.getMessage()));
            }
        } else if ("TEMP_AREA".equalsIgnoreCase(name)) {
            value = VerificationUtil.getEnv("TMPDIR");
            if (value == null || value.length() == 0) {
                value = System.getProperty("java.io.tmpdir");
            }
        } else if ("INSTALL_USER".equalsIgnoreCase(name)) {
            value = System.getProperty("user.name");
        } else if ("BACKUP_USER".equalsIgnoreCase(name)) {
            value = System.getProperty("user.name");
        } else if ("KERNEL_VER".equalsIgnoreCase(name)) {
            GlobalExecution globalExec = new GlobalExecution();
            try {
                String localNode = VerificationUtil.getLocalHost();
                ResultSet resultSet = new ResultSet();
                globalExec.checkKernelVersion(new String[]{localNode}, "", resultSet);
                Result result = resultSet.getResult(localNode);
                if (result.getStatus() == 1) {
                    value = result.getResultInfoSet().elementAt(0).toString();
                }
            }
            catch (UnknownHostException e) {
                Trace.out((String)("IGNORED: " + e.getClass() + ": " + e.getMessage()));
            }
        } else {
            value = sVerificationUtil.getVariableValue(name);
        }
        return value;
    }

    public static String getVariableValue(String variable) {
        String returnValue;
        block7: {
            returnValue = null;
            try {
                Pattern p = Pattern.compile("([^%]*)%([^%]+)%(.*)");
                Matcher m = p.matcher(variable);
                if (m.matches()) {
                    while (m.matches()) {
                        returnValue = m.group(1);
                        String resolvableVar = m.group(2);
                        String resolvedValue = VerificationUtil.resolveVariable(resolvableVar);
                        if (resolvedValue == null) {
                            returnValue = null;
                            break block7;
                        }
                        returnValue = returnValue + resolvedValue;
                        returnValue = returnValue + m.group(3);
                        m = p.matcher(returnValue);
                    }
                    break block7;
                }
                returnValue = VerificationUtil.resolveVariable(variable);
            }
            catch (Exception e) {
                Trace.out((String)("IGNORED EXCEPTION: " + e.getClass() + ":" + e.getMessage()));
            }
        }
        if (s_secVariable.contains(variable)) {
            Trace.out((String)("getting variable: VAR = " + variable + " VALUE=*****"));
        } else {
            Trace.out((String)("getting variable: VAR = " + variable + " VALUE=" + returnValue));
        }
        return returnValue;
    }

    public static void setVariableValue(String varName, String varValue) {
        if (s_secVariable.contains(varName)) {
            Trace.out((String)("setting variable: VAR = " + varName + " VALUE=*****"));
            VerificationLogData.logInfo("Variable set by client for CVU: VAR=" + varName + " VALUE=***");
        } else {
            Trace.out((String)("setting variable: VAR = " + varName + " VALUE=" + varValue));
            VerificationLogData.logInfo("Variable set by client for CVU: VAR=" + varName + " VALUE=" + varValue);
        }
        String oldValue = s_variableValueRepos.put(varName, varValue);
    }

    public static void clearVariableValue(String varName) {
        Trace.out((String)("clearing variable: VAR = " + varName));
        s_variableValueRepos.remove(varName);
    }

    public static void setupTracing(boolean isCLImode) {
        VerificationUtil.setupTracing(isCLImode, CLUVFY);
    }

    public static void setupTracing(boolean isCLImode, int whoIsIt) {
        int tracingLvl;
        boolean bAppend;
        String traceFileName;
        String traceProp = System.getProperty("TRACING.ENABLED");
        String traceLvl = System.getProperty("TRACING.LEVEL");
        boolean tracetostdout = false;
        boolean saveTraceState = false;
        if (traceProp != null && traceProp.equalsIgnoreCase("false")) {
            Trace.setSavePreviousLog((boolean)false);
            return;
        }
        if (!isCLImode) {
            return;
        }
        if (null != System.getProperty("TRACING.STDOUT")) {
            tracetostdout = true;
        }
        System.setProperty("TRACING.ENABLED", "true");
        if (!tracetostdout) {
            saveTraceState = Trace.isTraceEnabled();
            Trace.traceEnabled((boolean)false);
        }
        if ((traceFileName = VerificationUtil.getTraceFile(whoIsIt)) == null) {
            Trace.traceEnabled((boolean)false);
            return;
        }
        boolean bSavePreviousLog = VerificationUtil.isCVUTestEnv();
        boolean bl = bAppend = !bSavePreviousLog;
        if (!tracetostdout) {
            Trace.traceEnabled((boolean)saveTraceState);
        }
        Trace.setSavePreviousLog((boolean)bSavePreviousLog);
        if (traceLvl != null) {
            try {
                tracingLvl = Integer.parseInt(traceLvl);
            }
            catch (NumberFormatException e) {
                tracingLvl = 5;
            }
        } else {
            tracingLvl = 5;
        }
        Trace.enableTracing();
        Trace.setMaxLogOutputSize((int)100);
        Trace.setMaxLogOutputFiles((int)4);
        Trace.setTraceProcessOption((boolean)true);
        Trace.setTraceFilePerm((String)"0666");
        boolean conRes = Trace.configure((boolean)false, (boolean)tracetostdout, (boolean)true, (boolean)true, (String)traceFileName, (boolean)true, (boolean)bAppend);
        Trace.out((String)("Trace.configure returns " + conRes));
        Trace.setTraceLevel((int)tracingLvl);
        Trace.out((String)("tracing is on at level " + tracingLvl + " to file " + traceFileName));
    }

    private static String getTraceFile(int whoIsIt) {
        String errmsg;
        ClusterCmd clusterCmd;
        String traceFileName;
        String logDir;
        String fileSep;
        block18: {
            fileSep = System.getProperty("file.separator");
            logDir = VerificationUtil.getCVHome() + CV + fileSep + LOG;
            traceFileName = null;
            clusterCmd = new ClusterCmd();
            String traceLoc = VerificationUtil.getTraceLoc();
            if (traceLoc != null) {
                logDir = traceLoc;
            }
            errmsg = LSEP + s_msgBundle.getMessage("8503", false) + LSEP + s_msgBundle.getMessage("7728", false, (Object[])new String[]{logDir}) + LSEP;
            try {
                if (clusterCmd.isDirWritable(logDir)) break block18;
                File fLogDir = new File(logDir);
                try {
                    if (!fLogDir.exists()) {
                        try {
                            String[] lclNode = new String[]{VerificationUtil.getLocalHost()};
                            clusterCmd.createDirWithPermissionsOnNodes(lclNode, logDir, "775");
                        }
                        catch (UnknownHostException uhe) {
                            System.out.println(errmsg);
                            return traceFileName;
                        }
                        catch (ClusterException ce) {
                            System.out.println(errmsg);
                            return traceFileName;
                        }
                    }
                    if (clusterCmd.isDirWritable(logDir)) break block18;
                    String cmdToRun = "chmod 775 " + logDir;
                    try {
                        Runtime rt = Runtime.getRuntime();
                        Process proc = rt.exec(cmdToRun);
                        int ret = proc.waitFor();
                    }
                    catch (IOException e) {
                        System.out.println(errmsg);
                        return traceFileName;
                    }
                    catch (InterruptedException e) {
                        System.out.println(errmsg);
                        return traceFileName;
                    }
                }
                catch (SecurityException e) {
                    System.out.println(errmsg);
                    return traceFileName;
                }
                catch (ClusterException ce) {
                    System.out.println(errmsg);
                    return traceFileName;
                }
            }
            catch (ClusterException ce) {
                System.out.println(errmsg);
                return traceFileName;
            }
        }
        try {
            if (!clusterCmd.isDirWritable(logDir)) {
                System.out.println(errmsg);
                return traceFileName;
            }
        }
        catch (ClusterException ce) {
            System.out.println(errmsg);
            return traceFileName;
        }
        if (whoIsIt == CLUVFY) {
            traceFileName = logDir + fileSep + TRACE_CLUVFY_FNAME;
        }
        if (Trace.isLevelEnabled((int)3)) {
            Trace.out((String)("Using trace file: '" + traceFileName + "'"));
        }
        return traceFileName;
    }

    public static long sizeInBytes(long size, StorageUnit unit) {
        switch (unit) {
            case BYTE: {
                return size;
            }
            case KBYTE: {
                return size * KILO_BYTE;
            }
            case MBYTE: {
                return size * MEGA_BYTE;
            }
            case GBYTE: {
                return size * GIGA_BYTE;
            }
            case TBYTE: {
                return size * TERA_BYTE;
            }
        }
        return -1L;
    }

    public static double sizeInBytes(double size, StorageUnit unit) {
        switch (unit) {
            case BYTE: {
                return size;
            }
            case KBYTE: {
                return size * 1024.0;
            }
            case MBYTE: {
                return size * 1024.0 * 1024.0;
            }
            case GBYTE: {
                return size * 1024.0 * 1024.0 * 1024.0;
            }
            case TBYTE: {
                return size * 1024.0 * 1024.0 * 1024.0 * 1024.0;
            }
        }
        return -1.0;
    }

    public static double sizeInSpecificUnit(long size, StorageUnit unit) {
        switch (unit) {
            case BYTE: {
                return size;
            }
            case KBYTE: {
                return size / KILO_BYTE;
            }
            case MBYTE: {
                return size / MEGA_BYTE;
            }
            case GBYTE: {
                return size / GIGA_BYTE;
            }
            case TBYTE: {
                return size / TERA_BYTE;
            }
        }
        return -1.0;
    }

    public static String getCompleteMessage(Throwable e) {
        Throwable nextCause;
        StringBuffer sb = new StringBuffer();
        Throwable thrw = e;
        sb.append(e.getMessage());
        while ((nextCause = thrw.getCause()) != null) {
            sb.append(LSEP + nextCause.getMessage());
            thrw = nextCause;
        }
        return sb.toString();
    }

    public static String[] getDefaultDiscoveryDevice(String version) {
        return new sVerificationUtil().getDefaultDiscoveryDevice(version);
    }

    public static boolean containsWildCard(String path) {
        return new sVerificationUtil().containsWildCard(path);
    }

    public static String getFileListCommand() {
        return new sVerificationUtil().getFileListCommand();
    }

    public static List parseFileListOutput(String[] cmdOut) {
        return new sVerificationUtil().parseFileListOutput(cmdOut);
    }

    public static String getOraInventoryGroup() {
        return sVerificationUtil.getOraInventoryGroup();
    }

    public static String getOSAsmGroup(String loc) throws CVUException {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (nativeSystem.isUnixSystem()) {
            VerificationUtil.getAdmnGrps(loc, true);
            Trace.out((String)("Returning OSASM group: '" + m_osAsmGroup + "'"));
            return m_osAsmGroup;
        }
        Trace.out((String)"Returning 'null'");
        return null;
    }

    public static String getASMAdminGroup() throws CVUException {
        return VerificationUtil.getASMAdminGroup(null);
    }

    public static String getASMAdminGroup(String loc) throws CVUException {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (nativeSystem.isUnixSystem()) {
            VerificationUtil.getAdmnGrps(loc, false);
            Trace.out((String)("Returning ASMAdmin group: '" + m_asmAdminGroup + "'"));
            return m_asmAdminGroup;
        }
        String crsHomeForASM = VerificationUtil.getCRSHome();
        String asmGroup = null;
        try {
            asmGroup = nativeSystem.getASMAdminGroup(crsHomeForASM);
        }
        catch (NativeException e) {
            Trace.out((String)("ERROR: Problem in getting ASMADMIN group from CRS Home: '" + crsHomeForASM + "'"));
            Trace.out((String)("NATIVEEXCEPTION: \n" + e.getMessage()));
            Trace.stackTrace();
            String errorMsg = s_msgBundle.getMessage("5151", true, (Object[])new String[]{crsHomeForASM});
            throw new CVUException(errorMsg);
        }
        return asmGroup;
    }

    public static String getOSOPERGroup(String loc) throws CVUException {
        VerificationUtil.getAdmnGrps(loc, true);
        Trace.out((String)("Returning OSOPER group: '" + m_osOperGroup + "'"));
        return m_osOperGroup;
    }

    public static String getASMOPERGroup(String loc) throws CVUException {
        VerificationUtil.getAdmnGrps(loc, false);
        Trace.out((String)("Returning ASMOPER group: '" + m_asmOperGroup + "'"));
        return m_asmOperGroup;
    }

    public static String getOSDBAGroup(String loc) throws CVUException {
        VerificationUtil.getAdmnGrps(loc, true);
        Trace.out((String)("Returning OSDBA group: '" + m_osDbaGroup + "'"));
        return m_osDbaGroup;
    }

    public static String getASMDBAGroup(String loc) throws CVUException {
        VerificationUtil.getAdmnGrps(loc, false);
        Trace.out((String)("Returning ASMDBA group: '" + m_asmDbaGroup + "'"));
        return m_asmDbaGroup;
    }

    public static String getOSBACKUPDBAGroup(String loc) throws CVUException {
        VerificationUtil.getAdmnGrps(loc, true);
        Trace.out((String)("Returning OSBACKUPDBA group: '" + m_osBackupDBAGroup + "'"));
        return m_osBackupDBAGroup;
    }

    public static String getOSDGDBAGroup(String loc) throws CVUException {
        VerificationUtil.getAdmnGrps(loc, true);
        Trace.out((String)("Returning OSDGDBA group: '" + m_osDgDBAGroup + "'"));
        return m_osDgDBAGroup;
    }

    public static String getOSKMDBAGroup(String loc) throws CVUException {
        VerificationUtil.getAdmnGrps(loc, true);
        Trace.out((String)("Returning OSKMDBA group: '" + m_osKmDBAGroup + "'"));
        return m_osKmDBAGroup;
    }

    private static void getAdmnGrps(String loc, boolean dbhome) throws CVUException {
        String osdbagrpPath = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            Trace.out((String)"Not on Unix system, do nothing.");
            return;
        }
        Version sourceHomeVersion = VerificationUtil.getCRSActiveVersionObj();
        if (!dbhome) {
            if (m_getAdminGroups) {
                return;
            }
            osdbagrpPath = VerificationUtil.isStringGood(loc) ? loc + File.separator + "bin" : VerificationUtil.getCRSHome() + File.separator + "bin";
            try {
                Trace.out((String)("CRS: Calling OSDBAGRPUtil from: '" + osdbagrpPath + "'"));
                m_adminGroups = new ClusterwareInfo().getAdminGroups(osdbagrpPath, sourceHomeVersion != null ? sourceHomeVersion : new Version());
                m_asmOperGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSOPER"));
                m_asmAdminGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSASM"));
                m_asmDbaGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSDBA"));
                Trace.out((String)("Setting 'm_asmDbaGroup' to: '" + m_asmDbaGroup + "'\n" + "Setting 'm_asmOperGroup' to: '" + m_asmOperGroup + "'\n" + "Setting 'm_asmAdminGroup' to: '" + m_asmAdminGroup + "'\n"));
                m_getAdminGroups = true;
            }
            catch (InstallException ie) {
                Trace.out((String)("INSTALLEXCEPTION: " + ie.getMessage()));
                String errorMsg = s_gMsgBundle.getMessage("11318", true, (Object[])new String[]{ie.getMessage()});
                VerificationLogData.logError("InstallException: " + errorMsg);
                if (!m_groupExceptionReported) {
                    Trace.out((String)"Exception not reported, inform user.");
                    m_groupExceptionReported = true;
                    ReportUtil.printError(errorMsg);
                }
                return;
            }
        }
        if (!VerificationUtil.isStringGood(loc) || m_getRACGroups) {
            Trace.out((String)("Either the location '" + loc + "' is not valid, " + "or we already got the RAC groups '" + m_getRACGroups + "'"));
            return;
        }
        osdbagrpPath = loc + File.separator + "bin";
        try {
            Trace.out((String)("RAC/DB: Calling OSDBAGRPUtil from: '" + osdbagrpPath + "'"));
            m_adminGroups = new ClusterwareInfo().getAdminGroups(osdbagrpPath, sourceHomeVersion != null ? sourceHomeVersion : new Version());
            m_osOperGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSOPER"));
            m_osAsmGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSASM"));
            m_osDbaGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSDBA"));
            m_osBackupDBAGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSBACKUP"));
            m_osDgDBAGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSDG"));
            m_osKmDBAGroup = VerificationUtil.removeBrackets(m_adminGroups.get("SYSKM"));
            Trace.out((String)("Setting 'm_osDbaGroup' to: '" + m_osDbaGroup + "'\n" + "Setting 'm_osOperGroup' to: '" + m_osOperGroup + "'\n" + "Setting 'm_osAsmGroup' to: '" + m_osAsmGroup + "'\n" + "Setting 'm_osBackupDBAGroup' to: '" + m_osBackupDBAGroup + "'\n" + "Setting 'm_osDgDBAGroup' to: '" + m_osDgDBAGroup + "'\n" + "Setting 'm_osKmDBAGroup' to: '" + m_osKmDBAGroup + "'"));
            m_getRACGroups = true;
        }
        catch (InstallException ie) {
            Trace.out((String)("INSTALLEXCEPTION: " + ie.getMessage()));
            String errorMsg = s_gMsgBundle.getMessage("11318", true, (Object[])new String[]{ie.getMessage()});
            VerificationLogData.logError("InstallException: " + errorMsg);
            if (!m_groupExceptionReported) {
                Trace.out((String)"Exception not reported, inform user.");
                m_groupExceptionReported = true;
                ReportUtil.printError(errorMsg);
            }
            return;
        }
    }

    private static String removeBrackets(String brcktStr) {
        String noBrcktGrpName;
        if (!VerificationUtil.isStringGood(brcktStr)) {
            return brcktStr;
        }
        int opnBrckt = brcktStr.indexOf("[");
        int clsBrckt = brcktStr.indexOf("]");
        String tmpStr = new String(brcktStr);
        if (brcktStr.contentEquals("[]")) {
            Trace.out((String)("Input string: '" + brcktStr + "' returning <null>"));
            return null;
        }
        if (clsBrckt != -1) {
            tmpStr = noBrcktGrpName = tmpStr.substring(0, clsBrckt);
        }
        if (opnBrckt != -1) {
            tmpStr = noBrcktGrpName = tmpStr.substring(opnBrckt + 1);
        }
        Trace.out((String)("Removed brackets from: '" + brcktStr + "' and returned: '" + tmpStr + "'"));
        return tmpStr;
    }

    public static String getUSMDriverStatePath() {
        return new String(VerificationUtil.getCRSHome() + FSEP + "bin" + FSEP + new sVerificationUtil().getUSMDriverScript());
    }

    public static String getUSMDeviceOwner() {
        return new sVerificationUtil().getUSMDeviceOwner();
    }

    public static String getDefaultUSMDevPerms() {
        return new sVerificationUtil().getDefaultUSMDevPerms();
    }

    public static boolean checkPlatform() {
        String osname = sVerificationUtil.getCurrentOS();
        String osarch = sVerificationUtil.getCurrentArch();
        return sVerificationUtil.checkPlatform(osname, osarch);
    }

    public static String getCurrentOS() {
        return sVerificationUtil.getCurrentOS();
    }

    public static String getCurrentArch() {
        return sVerificationUtil.getCurrentArch();
    }

    public static boolean checkPlatform(String osname, String osarch) {
        Trace.out((String)("Check Platform: osname=" + osname + " ; osarch=" + osarch));
        return sVerificationUtil.checkPlatform(osname, osarch);
    }

    public static boolean checkPlatformOS() {
        Trace.out((String)"Check Platform OS.");
        String osname = sVerificationUtil.getCurrentOS();
        return sVerificationUtil.checkPlatformOS(osname);
    }

    public static boolean checkPlatformOS(String osname) {
        Trace.out((String)("Check Platform OS: osname=" + osname));
        return sVerificationUtil.checkPlatformOS(osname);
    }

    public static String getSupportedOS() {
        return sVerificationUtil.getSupportedOS();
    }

    public static String getSupportedArch() {
        return sVerificationUtil.getSupportedArch();
    }

    public static String getInventoryConfigFilePointer() throws InventoryFilePointerException {
        String defaultInvPtr = sVerificationUtil.getInventoryConfigFilePointer();
        String invPtrProp = System.getProperty(ORA_INST_INVPTR_PROPERTY);
        String invPtr = defaultInvPtr;
        boolean crs_or_siha = true;
        try {
            ClusterwareInfo cluInfo = new ClusterwareInfo();
            if (!VerificationUtil.isCRSConfigured() && !cluInfo.isHAConfigured()) {
                crs_or_siha = false;
            }
        }
        catch (InstallException ie) {
            Trace.out((Exception)((Object)ie));
            crs_or_siha = false;
        }
        if (crs_or_siha) {
            if (invPtrProp != null && !invPtrProp.equals(defaultInvPtr)) {
                throw new InventoryFilePointerException(s_msgBundle.getMessage("7608", false, (Object[])new String[]{ORA_INST_INVPTR_PROPERTY, defaultInvPtr, invPtrProp}));
            }
        } else if (invPtrProp != null && invPtrProp.length() != 0) {
            invPtr = invPtrProp;
        }
        return invPtr;
    }

    private static void reportException(Exception e) {
        String errMsg = e.getMessage();
        if (errMsg != null && errMsg.length() != 0) {
            ReportUtil.printError(errMsg);
        }
        Trace.out((Exception)e);
    }

    public static boolean isAbsoluteURI(String str) {
        return str.startsWith("file:") || str.startsWith("http:");
    }

    public static void setPreReqXmlFile(String xmlFilePath) throws VerificationException {
        Trace.out((String)("setting xml file: PATH = " + xmlFilePath));
        s_genericPreReqXmlFile = xmlFilePath;
    }

    public static void setPreReqXmlFile(VerificationType prereqType, String xmlFilePath) throws VerificationException {
        Trace.out((String)("setting xml file: PATH = " + xmlFilePath + " verification type =" + (Object)((Object)prereqType)));
        s_preReqXmlRepos.put(prereqType, xmlFilePath);
    }

    public static String getCTSSCheckCommand() {
        String crshome = VerificationUtil.getCRSHome();
        if (crshome == null) {
            return null;
        }
        return crshome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + CTSS_CHECK_COMMAND;
    }

    public static float getCTSSOffsetLimit() {
        return sVerificationUtil.getCTSSOffsetLimit();
    }

    public static String getCTSSResStatCommand() {
        String crshome = VerificationUtil.getCRSHome();
        if (crshome == null) {
            return null;
        }
        return crshome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + CTSS_RES_QUERY_COMMAND;
    }

    public static String getVDiskPermissions() {
        return VDISK_DEFAULT_PERMISSIONS;
    }

    public static String getOCROwner() {
        return VDMUtil.getDefaultOcrOwner();
    }

    public static String getOCRPermissions() {
        return VDMUtil.getDefaultOcrPermissions();
    }

    public static boolean isASMPath(String inpath) {
        return inpath.contains(ASM_PATH_CHARACTER);
    }

    public static String getCvuqdiskRPMname() {
        return CVUQDISK_RPM_FILE_NAME;
    }

    public static boolean isVersionPre(String version, int majorVersion, int minorVersion) {
        String versionSeparator = ".";
        String requiredVersion = Integer.toString(majorVersion) + versionSeparator + Integer.toString(minorVersion);
        return VerificationUtil.isVersionPre(version, requiredVersion);
    }

    public static boolean isVersionPre(String version, String requiredVersion) {
        String versionSeparator = ".";
        int comparisonResult = new VersionComparator(versionSeparator).compare(version, requiredVersion);
        return comparisonResult < 0;
    }

    public static boolean isVersionPost(String version, String requiredVersion) {
        String versionSeparator = ".";
        int comparisonResult = new VersionComparator(versionSeparator).compare(version, requiredVersion);
        return comparisonResult >= 0;
    }

    public static boolean isCVUTestEnv() {
        String sysprop = System.getProperty("CVU_TEST_ENV");
        if (sysprop == null || sysprop.trim().length() <= 0) {
            sysprop = VerificationUtil.getEnv("CVU_TEST_ENV");
        }
        return Boolean.parseBoolean(sysprop);
    }

    public static String getLoginShell() {
        return sVerificationUtil.getLoginShell();
    }

    public static boolean isACFSSupported(boolean dispError) {
        String crsHome = VerificationUtil.getCRSHome();
        String errMsg = null;
        boolean isSupported = false;
        if (crsHome == null) {
            if (dispError) {
                errMsg = s_msgBundle.getMessage("5301", true);
                ReportUtil.printError(errMsg);
                Trace.out((String)errMsg);
            }
            Trace.out((String)"Could not retrieve CRS Home, failed to retrieve an informatin about ACFS support on this platform");
            return false;
        }
        try {
            USMDriverUtil usmUtil = new USMDriverUtil(crsHome);
            isSupported = usmUtil.checkACFSState(USMDriverUtil.ACFSDriverState.SUPPORTED, crsHome);
        }
        catch (CmdToolUtilException e) {
            if (dispError) {
                VerificationUtil.reportException((Exception)((Object)e));
            }
            Trace.out((String)"An exception occured while retrieving information about ACFS support for this platform.");
            return false;
        }
        if (isSupported) {
            Trace.out((String)"ACFS is supported on this platform.");
            return true;
        }
        if (dispError) {
            ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("1300", true));
        }
        Trace.out((String)"ACFS is NOT supported on this platform.");
        return false;
    }

    public static boolean isUDEVSupported() {
        return sVerificationUtil.isUDEVSupported();
    }

    public static String getVersionForCL() {
        String version = VerificationUtil.getEnv(ASSUME_CL_VERSION);
        if (version != null && version.length() > 0) {
            return version;
        }
        version = VerificationUtil.getConfiguredValue(ASSUME_CL_VERSION, true);
        if (version != null && version.length() > 0) {
            return version;
        }
        version = VerificationUtil.isHAConfigured() ? VerificationUtil.getSIHAReleaseVersion(true) : VerificationUtil.getCRSActiveVersion(true);
        if (version != null && version.length() > 0) {
            return version;
        }
        return "12.1.0.1.0";
    }

    public static String getSudoPbrunLocationFromConfigFile(ConfigurationSetup.ConfigMethod method) {
        String m_sudoPbrunloc = null;
        String binaryName = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (method != null) {
            switch (method) {
                case ROOT: {
                    return null;
                }
                case PBRUN: {
                    m_sudoPbrunloc = VerificationUtil.getConfiguredValue(PBRUN_LOCATION_PATH, true);
                    binaryName = nativeSys.getExeName(ConfigurationSetup.ConfigMethod.PBRUN.toString().toLowerCase());
                    break;
                }
                case SUDO: {
                    m_sudoPbrunloc = VerificationUtil.getConfiguredValue(SUDO_LOCATION_PATH, true);
                    binaryName = "sudo";
                }
            }
        }
        if (!VerificationUtil.isStringGood(m_sudoPbrunloc)) {
            m_sudoPbrunloc = "/usr/local/bin/" + binaryName;
        }
        return m_sudoPbrunloc;
    }

    public static boolean isUpgrade() {
        return "UPGRADE".equalsIgnoreCase(VerificationUtil.getVariableValue("INSTALL_OPTION"));
    }

    public static boolean isCRSSoftwareOnlyInstall() {
        return "CRS_SWONLY".equalsIgnoreCase(VerificationUtil.getVariableValue("INSTALL_OPTION"));
    }

    public static boolean isCVUResource() {
        String mode = System.getProperty("RUNNING.MODE");
        return mode != null && mode.equalsIgnoreCase("cvuresource");
    }

    public static String getLogFileName() {
        if (!VerificationUtil.isCVUResource()) {
            return null;
        }
        if (s_cvuLogFile != null) {
            return s_cvuLogFile;
        }
        String strTimeStamp = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        strTimeStamp = sdf.format(new Date());
        s_cvuLogFile = System.getProperty("CV_LOG_LOCATION") + FILE_SEPARATOR + "cvu" + strTimeStamp + ".log";
        Trace.out((String)("writing to " + s_cvuLogFile));
        return s_cvuLogFile;
    }

    public static void deleteLogFiles() {
        if (!VerificationUtil.isCVUResource()) {
            return;
        }
        String logDir = System.getProperty("CV_LOG_LOCATION");
        File directory = new File(logDir);
        if (directory.exists()) {
            File[] listFiles = directory.listFiles();
            long purgeTime = System.currentTimeMillis() - -1702967296L;
            for (File listFile : listFiles) {
                if (listFile.lastModified() >= purgeTime || listFile.delete()) continue;
                ReportUtil.sureprintln(s_msgBundle.getMessage("7555", false, (Object[])new String[]{logDir}));
                return;
            }
        }
    }

    public static String getTZFileLoc() {
        return sVerificationUtil.getTZFileLoc();
    }

    public static OIFCFGInfo getOIFCFGInfo(String node, boolean preCheck) throws VerificationException {
        String cvHome = VerificationUtil.getCVHome();
        String oifcfgLocation = cvHome + "bin";
        String crsHome = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        boolean isWindows = !nativeSys.isUnixSystem();
        boolean lightWeight = true;
        ParamManager pm = null;
        boolean isAPIMode = false;
        if (!preCheck) {
            crsHome = VerificationUtil.getCRSHome();
            if (crsHome != null) {
                Trace.out((String)"post check crshome not null");
                return new OIFCFGInfo(crsHome + FSEP + "bin", false);
            }
            throw new VerificationException(s_msgBundle.getMessage("7593", false, (Object[])new String[]{node}));
        }
        String installOption = VerificationUtil.getVariableValue("INSTALL_OPTION");
        String configOption = VerificationUtil.getVariableValue("POST_SW_INSTALL_API_MODE");
        boolean isPostSWConfig = false;
        if (configOption != null && configOption.equalsIgnoreCase("true")) {
            isPostSWConfig = true;
        }
        try {
            pm = ParamManager.getInstance();
            if (pm.getMode() == ParamManager.OperationMode.MODE_API) {
                isAPIMode = true;
            }
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        if (!preCheck && !isAPIMode) {
            crsHome = VerificationUtil.getCRSHome();
            Trace.out((String)("crshome got is : " + crsHome));
        } else if (installOption != null && !installOption.equalsIgnoreCase("CRS_CONFIG") && installOption != null && !installOption.equalsIgnoreCase("HA_CONFIG")) {
            crsHome = VerificationUtil.getCRSHome();
            Trace.out((String)("crshome obtained is " + crsHome));
        }
        if (!isAPIMode && pm.checkInstallConfigFile()) {
            if (crsHome != null) {
                oifcfgLocation = crsHome;
                lightWeight = false;
            } else {
                oifcfgLocation = cvHome + "bin";
                lightWeight = true;
            }
        } else if (crsHome != null) {
            if (isAPIMode && "UPGRADE".equalsIgnoreCase(installOption)) {
                if (isPostSWConfig) {
                    oifcfgLocation = VerificationUtil.getInstallBinariesLocWhenPostSWConfig();
                    Trace.out((String)"post software install configuraion in upgrade api mode");
                } else {
                    oifcfgLocation = !isWindows ? cvHome + ".." + FSEP + "ext" + FSEP + "bin" : System.getProperty("oracle.installer.scratchPath") + FSEP + "ext" + FSEP + "bin";
                    Trace.out((String)"upgrade api mode using lightweight oifcfg");
                }
            } else {
                lightWeight = false;
                oifcfgLocation = crsHome + FSEP + "bin";
                Trace.out((String)"using oifcfg from crshome");
            }
        } else if (isAPIMode) {
            if (Utils.isDevelopmentEnv()) {
                oifcfgLocation = cvHome + FSEP + "bin";
                lightWeight = false;
                Trace.out((String)"cvu test env");
            } else if (isPostSWConfig) {
                oifcfgLocation = VerificationUtil.getInstallBinariesLocWhenPostSWConfig();
                Trace.out((String)"post software install configuraion mode");
            } else {
                oifcfgLocation = !isWindows ? cvHome + ".." + FSEP + "ext" + FSEP + "bin" : System.getProperty("oracle.installer.scratchPath") + FSEP + "ext" + FSEP + "bin";
                Trace.out((String)"shiphome test env");
            }
        } else if (Utils.isDevelopmentEnv()) {
            lightWeight = false;
            Trace.out((String)"cvu test env");
        }
        String OIFCFGUTL = nativeSys.getExeName("oifcfg");
        if (!new File(oifcfgLocation + FSEP + OIFCFGUTL).exists()) {
            Trace.out((String)(" oifcfg not found in " + oifcfgLocation));
            throw new VerificationException(s_msgBundle.getMessage("0054", true, (Object[])new String[]{oifcfgLocation}));
        }
        Trace.out((String)("using " + lightWeight + " oifcfg"));
        OIFCFGInfo oifcfgInfo = new OIFCFGInfo(oifcfgLocation, lightWeight);
        return oifcfgInfo;
    }

    private static String getInstallBinariesLocWhenPostSWConfig() throws VerificationException {
        String oHome = VerificationUtil.getVariableValue("ORACLE_HOME");
        if (oHome == null || oHome.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("5461", true, (Object[])new String[]{"ORACLE_HOME"}));
        }
        return oHome + FSEP + "inventory" + FSEP + "Scripts" + FSEP + "ext" + FSEP + "bin";
    }

    public static List<InterfaceInfo> getIPNetworks(String node, InetAddress ipAddress, boolean preCheck) throws InstallException, CVUException {
        ClusterNetworkInfo cnInfo = null;
        ArrayList<InterfaceInfo> ipNetworkList = new ArrayList<InterfaceInfo>();
        ArrayList<InterfaceInfo> ifInfoList = new ArrayList<InterfaceInfo>();
        byte[] ipAddressBytes = ipAddress.getAddress();
        cnInfo = preCheck ? ClusterNetworkInfo.getNetworkInfoFromCVUVar() : ClusterNetworkInfo.getNetworkInfoFromOifcfg();
        VerifyNetwork vfyNetwork = new VerifyNetwork();
        try {
            vfyNetwork.getInterfaceInfo(node, cnInfo, ifInfoList);
        }
        catch (NetworkException netEx) {
            Trace.out((String)("Networkexception occured while trying to get interfaces info on " + node + ". msg:" + netEx.getMessage()));
            throw new CVUException(netEx);
        }
        catch (MultiNodeException nmEx) {
            Trace.out((String)("MultiNodeException occured while trying to get interfaces info on " + node + ". msg:" + nmEx.getMessage()));
            throw new CVUException(nmEx);
        }
        String notMatchIPaddress = "";
        InetAddress resultingSubnet = null;
        InetAddress subnetMask = null;
        InetAddress subnet = null;
        for (InterfaceInfo ifInfo : ifInfoList) {
            try {
                subnetMask = InetAddress.getByName(ifInfo.getNetMask());
                subnet = InetAddress.getByName(ifInfo.getSubnet());
                byte[] subnetMaskBytes = subnetMask.getAddress();
                if (ipAddressBytes.length != subnetMaskBytes.length) {
                    String s = ifInfo.getSubnet();
                    if (notMatchIPaddress.indexOf(s) != -1) continue;
                    notMatchIPaddress = notMatchIPaddress.concat(s + ", ");
                    continue;
                }
                byte[] resultingSubnetBytes = new byte[ipAddressBytes.length];
                for (int i = 0; i < ipAddressBytes.length; i = (int)((byte)(i + 1))) {
                    resultingSubnetBytes[i] = Integer.valueOf(Byte.valueOf(ipAddressBytes[i]).intValue() & Byte.valueOf(subnetMaskBytes[i]).intValue()).byteValue();
                }
                resultingSubnet = InetAddress.getByAddress(resultingSubnetBytes);
                if (resultingSubnet.equals(subnet)) {
                    ipNetworkList.add(ifInfo);
                    continue;
                }
                String s = ifInfo.getSubnet();
                if (notMatchIPaddress.indexOf(s) != -1) continue;
                notMatchIPaddress = notMatchIPaddress.concat(s + ", ");
            }
            catch (UnknownHostException ohe) {
                throw new InstallException((MessageKey)PrCiMsgID.INVALID_RESULTING_SUBNET_FORMAT, new Object[]{subnetMask.getHostAddress(), ipAddress.getHostAddress()});
            }
        }
        if (ipNetworkList.size() == 0) {
            throw new InstallException((MessageKey)PrCiMsgID.IPADDR_SUBNETMASK_MISMATCH, new Object[]{ipAddress.getHostAddress(), notMatchIPaddress.substring(0, notMatchIPaddress.length() - 2)});
        }
        return ipNetworkList;
    }

    public static List<OIFCFGResult> resolveSubNetMask(List<OIFCFGResult> oifcfgGetifList, List<OIFCFGResult> oifcfgIfList, OIFCFGUtil oifcfgUtil) {
        ArrayList<OIFCFGResult> updatedList = new ArrayList<OIFCFGResult>();
        block0: for (OIFCFGResult getifElem : oifcfgGetifList) {
            for (OIFCFGResult iflstElem : oifcfgIfList) {
                if (!iflstElem.getInterfaceName().equalsIgnoreCase(getifElem.getInterfaceName()) || !iflstElem.getSubnet().equals(getifElem.getSubnet()) || iflstElem.getType() != getifElem.getType()) continue;
                Trace.out((String)("updating " + getifElem.getInterfaceName() + "'s subnet"));
                updatedList.add(oifcfgUtil.getOIFCFGResultObj(getifElem.getInterfaceName(), getifElem.getSubnet(), getifElem.getInterfaceType(), iflstElem.getSubnetMask(), getifElem.getNodeScope()));
                continue block0;
            }
        }
        return updatedList;
    }

    public static String getKFODLocation(String node, boolean preCheck) throws VerificationException {
        boolean isWindows;
        String cvHome = VerificationUtil.getCVHome();
        String crsHome = null;
        boolean lightWeight = true;
        ParamManager pm = null;
        boolean isAPIMode = false;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        boolean bl = isWindows = !nativeSys.isUnixSystem();
        if (!preCheck) {
            crsHome = VerificationUtil.getCRSHome();
            if (crsHome != null) {
                if (Utils.isDevelopmentEnv()) {
                    Trace.out((String)"post check dev env");
                    return crsHome + FSEP + "rdbms" + FSEP + "bin";
                }
                Trace.out((String)"post check crshome was found");
                return crsHome + FSEP + "bin";
            }
            throw new VerificationException(s_msgBundle.getMessage("7593", true, (Object[])new String[]{node}));
        }
        try {
            pm = ParamManager.getInstance();
            if (pm.getMode() == ParamManager.OperationMode.MODE_API) {
                isAPIMode = true;
            }
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        String installOption = VerificationUtil.getVariableValue("INSTALL_OPTION");
        String configOption = VerificationUtil.getVariableValue("POST_SW_INSTALL_API_MODE");
        boolean isPostSWConfig = false;
        if (configOption != null && configOption.equalsIgnoreCase("true")) {
            isPostSWConfig = true;
        }
        if (!isAPIMode) {
            crsHome = VerificationUtil.getCRSHome();
            Trace.out((String)("crshome got is : " + crsHome));
        } else if (installOption != null && !installOption.equalsIgnoreCase("CRS_CONFIG") && installOption != null && !installOption.equalsIgnoreCase("HA_CONFIG")) {
            crsHome = VerificationUtil.getCRSHome();
            Trace.out((String)("crshome obtained is " + crsHome));
        }
        if (!isAPIMode && pm.checkInstallConfigFile()) {
            Trace.out((String)"cmdline mode with -file option before clusterware config");
            return crsHome;
        }
        if (crsHome != null) {
            if (isAPIMode && "UPGRADE".equalsIgnoreCase(installOption)) {
                if (isPostSWConfig) {
                    Trace.out((String)"post software install configuraion in upgrade api mode");
                    return VerificationUtil.getInstallBinariesLocWhenPostSWConfig();
                }
                Trace.out((String)"upgrade api mode using kfod from cvhome");
                if (!isWindows) {
                    return cvHome + ".." + FSEP + "ext" + FSEP + "bin";
                }
                return System.getProperty("oracle.installer.scratchPath") + FSEP + "ext" + FSEP + "bin";
            }
            Trace.out((String)"using  kfod from crshome");
            if (Utils.isDevelopmentEnv()) {
                Trace.out((String)"post check dev env");
                return crsHome + FSEP + "rdbms" + FSEP + "bin";
            }
            Trace.out((String)"post check crshome was found");
            return crsHome + FSEP + "bin";
        }
        if (isAPIMode) {
            if (Utils.isDevelopmentEnv()) {
                Trace.out((String)"cvu test env");
                return cvHome + "rdbms" + FSEP + "bin";
            }
            if (isPostSWConfig) {
                Trace.out((String)"post software install configuraion mode");
                return VerificationUtil.getInstallBinariesLocWhenPostSWConfig();
            }
            Trace.out((String)"shiphome test env");
            if (!isWindows) {
                return cvHome + ".." + FSEP + "ext" + FSEP + "bin";
            }
            return System.getProperty("oracle.installer.scratchPath") + FSEP + "ext" + FSEP + "bin";
        }
        if (Utils.isDevelopmentEnv()) {
            Trace.out((String)"cvu cmdline test env");
            return cvHome + "rdbms" + FSEP + "bin";
        }
        Trace.out((String)"default location");
        return cvHome + FSEP + "bin";
    }

    public static boolean isAutoMountEnabled(String node) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            return sVerificationUtil.isAutoMountEnabled(node);
        }
        return false;
    }

    public static boolean isAutoMountEnabled(String[] nodes) {
        boolean autoMntEnabled = true;
        for (String node : nodes) {
            if (VerificationUtil.isAutoMountEnabled(node)) continue;
            autoMntEnabled = false;
        }
        return autoMntEnabled;
    }

    public static String[] getLdLibraryStrings() {
        return sVerificationUtil.getLdLibraryStrings();
    }

    public static Vector<String> tagHashFilter(String input, String tagPattern) {
        String retstr = "";
        String pattern = "#" + tagPattern + "#";
        Vector<String> tokenList = new Vector<String>();
        if (VerificationUtil.isStringGood(input) && VerificationUtil.isStringGood(pattern) && input.contains(pattern)) {
            int endpos;
            int beginpos;
            String copy = input;
            while (copy.contains(pattern) && (beginpos = copy.indexOf(pattern)) >= 0 && (endpos = (copy = copy.substring(beginpos + pattern.length())).indexOf(pattern)) >= 0) {
                String value = copy.substring(0, endpos);
                Trace.out((String)("Retrieved the value from Tag hashes as :" + value));
                copy = copy.substring(endpos + pattern.length());
                if (!VerificationUtil.isStringGood(value)) continue;
                tokenList.add(value.trim());
            }
        }
        return tokenList;
    }

    public static String[] getOCRLocations(Version version, ResultSet resultSet) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            return VerificationUtil.getOCRLocationsUnix(version, resultSet);
        }
        return VerificationUtil.getOCRLocationsWindows(version, resultSet);
    }

    private static String[] getOCRLocationsUnix(Version version, ResultSet resultSet) {
        ArrayList<String> ocrLocList = new ArrayList<String>();
        String ocrLoc = null;
        String fileName = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        fileName = nativeSys.getConfigLocation(version);
        String ocrConfigPropName = Version.isPre10i((Version)version) ? "srvconfig_loc" : "ocrconfig_loc";
        String ocrMirrorPropName = "ocrmirrorconfig_loc";
        String ocrConfig3PropNameLocation = "ocrconfig_loc3";
        String ocrConfig4PropNameLocation = "ocrconfig_loc4";
        String ocrConfig5PropNameLocation = "ocrconfig_loc5";
        try {
            ocrLoc = Utils.getPropertyValue((String)fileName, (String)ocrConfigPropName, (boolean)true);
            if (ocrLoc != null) {
                ocrLocList.add(ocrLoc);
            }
            if ((ocrLoc = Utils.getPropertyValue((String)fileName, (String)ocrMirrorPropName, (boolean)true)) != null) {
                ocrLocList.add(ocrLoc);
            }
            if ((ocrLoc = Utils.getPropertyValue((String)fileName, (String)ocrConfig3PropNameLocation, (boolean)true)) != null) {
                ocrLocList.add(ocrLoc);
            }
            if ((ocrLoc = Utils.getPropertyValue((String)fileName, (String)ocrConfig4PropNameLocation, (boolean)true)) != null) {
                ocrLocList.add(ocrLoc);
            }
            if ((ocrLoc = Utils.getPropertyValue((String)fileName, (String)ocrConfig5PropNameLocation, (boolean)true)) != null) {
                ocrLocList.add(ocrLoc);
            }
        }
        catch (FileNotFoundException e) {
            Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
            resultSet.setStatus(2);
            resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            return null;
        }
        catch (IOException e) {
            Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
            resultSet.setStatus(2);
            resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            return null;
        }
        resultSet.setStatus(1);
        return ocrLocList.toArray(new String[0]);
    }

    private static String[] getOCRLocationsWindows(Version version, ResultSet resultSet) {
        ErrorDescription errorDescription;
        MessageBundle msgBundle;
        String[] args;
        String ocrLoc;
        ArrayList<String> ocrLocList = new ArrayList<String>();
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String configLocation = nativeSys.getConfigLocation(version);
        String ocrConfigPropName = Version.isPre10i((Version)version) ? "srvconfig_loc" : "ocrconfig_loc";
        String ocrMirrorPropName = "ocrmirrorconfig_loc";
        RegistryKeyData regData = new RegistryKeyData(configLocation, ocrConfigPropName);
        String nodeName = null;
        NativeResult nativeResult = new NativeResult();
        if (nativeSys.regKeyExists(nodeName, configLocation, nativeResult)) {
            nativeResult.setStatus(false);
            nativeSys.regGetData(nodeName, configLocation, ocrConfigPropName, regData, nativeResult);
            if (nativeResult.getStatus() && (ocrLoc = regData.getStringData()) != null && ocrLoc.length() > 0) {
                ocrLocList.add(ocrLoc);
            }
        } else if (!nativeResult.getStatus()) {
            args = new String[]{ocrConfigPropName, configLocation, "localnode", nativeResult.getOSString()};
            msgBundle = VerificationUtil.getMessageBundle("Prvf");
            errorDescription = new ErrorDescription("1011", args, msgBundle);
            resultSet.setStatus(2);
            resultSet.addErrorDescription(errorDescription);
        }
        if (!Version.isPre10i((Version)version)) {
            regData = new RegistryKeyData(configLocation, ocrMirrorPropName);
            nativeResult = new NativeResult();
            if (nativeSys.regKeyExists(nodeName, configLocation, nativeResult)) {
                nativeResult.setStatus(false);
                nativeSys.regGetData(nodeName, configLocation, ocrMirrorPropName, regData, nativeResult);
                if (nativeResult.getStatus() && (ocrLoc = regData.getStringData()) != null && ocrLoc.length() > 0) {
                    ocrLocList.add(ocrLoc);
                }
            } else if (!nativeResult.getStatus()) {
                args = new String[]{ocrMirrorPropName, configLocation, "localnode", nativeResult.getOSString()};
                msgBundle = VerificationUtil.getMessageBundle("Prvf");
                errorDescription = new ErrorDescription("1011", args, msgBundle);
                resultSet.setStatus(2);
                resultSet.addErrorDescription(errorDescription);
            }
        }
        resultSet.setStatus(1);
        return ocrLocList.toArray(new String[0]);
    }

    public static String getDevicePathForAsmStamp(String node, String stamp, Result result) {
        ErrorDescription errDesc = null;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet stampDevResSet = new ResultSet();
        String winGlobalRootToken = "\\\\?\\GLOBALROOT";
        if (stamp == null || stamp.trim().length() == 0) {
            errDesc = new ErrorDescription(s_gMsgBundle.getMessage("10530", false, (Object[])new String[]{"stamp"}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        boolean res = globalExec.getDevicePathForAsmStamp(new String[]{node}, stamp, stampDevResSet);
        Result sdResult = (Result)stampDevResSet.getResultTable().get(node);
        String devicePath = null;
        if (sdResult.getStatus() == 1) {
            devicePath = (String)sdResult.getResultInfoSet().elementAt(0);
            if (devicePath != null && devicePath.trim().length() > 0) {
                devicePath = devicePath.trim();
                result.setStatus(1);
            }
        } else {
            errDesc = sdResult.getStatus() == 3 ? new ErrorDescription(s_gMsgBundle.getMessage("10520", true, (Object[])new String[]{stamp, node}), s_gMsgBundle, "10520") : new ErrorDescription(s_gMsgBundle.getMessage("10521", true, (Object[])new String[]{stamp, node}), s_gMsgBundle, "10521");
            result.addErrorDescription(errDesc);
            result.setStatus(sdResult.getStatus());
        }
        if (VerificationUtil.isStringGood(devicePath) && devicePath.toUpperCase().startsWith(winGlobalRootToken)) {
            Trace.out((String)"The resolved device path contains Global root prefix, truncating the global root prefix");
            devicePath = devicePath.substring(winGlobalRootToken.length());
            Trace.out((String)("Resoved stamp " + stamp + " to " + devicePath + " returning it"));
        }
        return devicePath;
    }

    public static List<String> resolveASMDiskStamps(String node, List<String> deviceList, Result result) {
        String orclStampToken = "ORCL";
        String windeviceRootToken = "\\\\.\\";
        result.setStatus(1);
        Trace.out((String)"Inside resolveASMDiskStamps");
        if (node != null && deviceList != null && deviceList.size() > 0) {
            ArrayList<String> newList = new ArrayList<String>(deviceList.size());
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            if (nativeSystem.isUnixSystem()) {
                orclStampToken = orclStampToken + ":";
            }
            for (String disk : deviceList) {
                String saveDiskStr = null;
                if (disk != null && disk.startsWith(windeviceRootToken)) {
                    Trace.out((String)("The disk name " + disk + " contains device token prefix"));
                    saveDiskStr = disk;
                    disk = disk.substring(windeviceRootToken.length());
                }
                Trace.out((String)("Processing Disk " + disk));
                if (disk != null && disk.startsWith(orclStampToken)) {
                    Trace.out((String)("Disk is ORCL type of disk, Now resolving " + disk + " to its device"));
                    result = new Result(node);
                    String resolvedPath = VerificationUtil.getDevicePathForAsmStamp(node, disk, result);
                    if (result.getStatus() == 1) {
                        newList.add(resolvedPath);
                        continue;
                    }
                    Trace.out((String)("Failed to resolve ORCL type of disk " + disk + " to its correct device path. Returning with Failure"));
                    return null;
                }
                if (saveDiskStr == null) {
                    newList.add(disk);
                    continue;
                }
                newList.add(saveDiskStr);
            }
            Trace.out((String)"All devices processed successfully.");
            result.setStatus(1);
            return newList;
        }
        result = new Result(node);
        if (node == null || node.trim().length() == 0) {
            result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"node"})));
        }
        if (deviceList == null || deviceList.size() == 0) {
            result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"deviceList"})));
        }
        result.setStatus(2);
        return null;
    }

    public static DiskInfoResultSet getDiskInfoForPath(String[] nodeList, String path) throws InvalidPathException {
        return sVerificationUtil.getDiskInfoForPath(nodeList, path);
    }

    public static SpaceResultSet getAvailableSpace(String[] nodeList, String path, boolean isWritePermissionRequired) {
        SpaceResultSetImpl spaceRsltSet = new SpaceResultSetImpl();
        ErrorDescription errorDesc = null;
        String errMsg = null;
        if (nodeList == null || nodeList.length == 0) {
            errMsg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"nodeList"});
            errorDesc = new ErrorDescription(errMsg);
            spaceRsltSet.addErrorDescription(errorDesc);
            spaceRsltSet.setStatus(2);
            return spaceRsltSet;
        }
        if (!VerificationUtil.isStringGood(path)) {
            errMsg = s_msgBundle.getMessage("7517", false);
            errorDesc = new ErrorDescription(errMsg);
            spaceRsltSet.addErrorDescription(errorDesc);
            spaceRsltSet.addResult(nodeList, 2);
            return spaceRsltSet;
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path + " isWritePermissionRequired=" + isWritePermissionRequired));
        }
        StorageUnit unit = StorageUnit.BYTE;
        ResultSet validPathResSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        HashMap<String, String> nodePath = new HashMap<String, String>();
        boolean cmdResult = false;
        cmdResult = globalExec.getLongestValidPath(nodeList, path, isWritePermissionRequired, validPathResSet);
        Hashtable ht = validPathResSet.getResultTable();
        Enumeration e = ht.keys();
        int nodeCount = ht.size();
        ArrayList<GetSpaceCommand> cmdList = new ArrayList<GetSpaceCommand>();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result pathResult = (Result)ht.get(node);
            if (pathResult.getStatus() == 1) {
                String longestPath = (String)pathResult.getResultInfoSet().firstElement();
                nodePath.put(node, longestPath);
                StorageInfo stInfo = null;
                try {
                    stInfo = new TypeFinder().getStorageInstance(longestPath, node);
                }
                catch (StorageException ste) {
                    MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
                    Trace.out((String)("StorageException encountered: " + ste));
                    errMsg = s_msgBundle.getMessage("4125", false, (Object[])new String[]{longestPath});
                    errorDesc = new ErrorDescription(errMsg);
                    spaceRsltSet.addErrorDescription(errorDesc);
                    spaceRsltSet.addResult(nodeList, 2);
                    return spaceRsltSet;
                }
                cmdList.add(new GetSpaceCommand(node, longestPath, stInfo.getName(), stInfo.getType(), stInfo));
                continue;
            }
            MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvg");
            errMsg = s_msgBundle.getMessage(isWritePermissionRequired ? "7051" : "7050", true, (Object[])new String[]{path, node});
            errorDesc = new ErrorDescription(errMsg);
            Result rslt = new Result(node, 2);
            rslt.addErrorDescription(errorDesc);
            spaceRsltSet.addResult(node, rslt);
        }
        ResultSet spaceResSet = new ResultSet();
        cmdResult = new GlobalHandler().submit(cmdList.toArray(new Command[0]), 0, spaceResSet);
        Enumeration e1 = spaceResSet.getResultTable().keys();
        while (e1.hasMoreElements()) {
            String node = (String)e1.nextElement();
            Trace.out((String)("--------- Execution Trace for GetSpaceCommand from node: " + node + " ------------"));
            Result result = (Result)spaceResSet.getResultTable().get(node);
            if (result.getStatus() == 1) {
                Long lAvl = (Long)result.getResultInfoSet().firstElement();
                long space = lAvl;
                String location = (String)nodePath.get(node);
                AvailableSpaceInfoImpl spaceInfo = new AvailableSpaceInfoImpl(node, location, space, unit);
                spaceRsltSet.addSpaceInfo(spaceInfo);
            }
            spaceRsltSet.addResult(node, result);
            Vector traceSet = result.getTraceInfoSet();
            Enumeration t = traceSet.elements();
            while (t.hasMoreElements()) {
                Trace.out((String)((String)t.nextElement()));
            }
        }
        return spaceRsltSet;
    }

    public static boolean isStringGood(String str) {
        return str != null && str.trim().length() > 0;
    }

    public static String readPassword(String prompt) {
        EraserThread et = new EraserThread(prompt);
        Thread mask = new Thread(et);
        mask.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String password = "";
        try {
            password = in.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        et.stopMasking();
        return password;
    }

    public static boolean isDisplayEnabled() {
        return sVerificationUtil.isDisplayEnabled();
    }

    public static String getOLRPropertyValue(String node, String propertyName, Result result, boolean ignoreCase) {
        return sVerificationUtil.getOLRPropertyValue(node, propertyName, result, ignoreCase);
    }

    public static String getOLRPropertyValueLocalNode(String propertyName, Result result, boolean ignoreCase) {
        return VerificationUtil.getOLRPropertyValue("localnode", propertyName, result, ignoreCase);
    }

    public static String getLocalRootGroup() {
        return sVerificationUtil.getLocalRootGroup();
    }

    public static String getRootUsername() {
        return sVerificationUtil.getRootUsername();
    }

    public static boolean skipTask(Task task) {
        boolean retVal = false;
        if (task instanceof TaskMulticastCheck) {
            if (!VerificationUtil.getSupportedOS().equals("SunOS")) {
                return false;
            }
            File cluFile = null;
            cluFile = new File("/opt/FJSVhanet/usr/sbin/hanetconfig");
            if (cluFile.exists()) {
                return true;
            }
        }
        return retVal;
    }

    public static double parseStringToNumber(String numberStr) {
        double value = 0.0;
        try {
            long lval = Long.parseLong(numberStr);
            value = lval;
        }
        catch (NumberFormatException e) {
            Trace.out((String)("Caught NumberFormatException while parsing " + numberStr + " as Long, Now trying to parse it as Double"));
            value = Double.parseDouble(numberStr);
        }
        return value;
    }

    public static String parseObjectToString(Object obj) {
        String strForObj = null;
        if (obj == null) {
            return strForObj;
        }
        if (obj instanceof Number) {
            if (obj instanceof Short) {
                strForObj = BigDecimal.valueOf(((Short)obj).shortValue()).toPlainString();
            } else if (obj instanceof Long) {
                strForObj = BigDecimal.valueOf((Long)obj).toPlainString();
            } else if (obj instanceof Integer) {
                strForObj = BigDecimal.valueOf(((Integer)obj).intValue()).toPlainString();
            } else if (obj instanceof Float) {
                strForObj = BigDecimal.valueOf(((Float)obj).floatValue()).toPlainString();
            } else if (obj instanceof Byte) {
                strForObj = BigDecimal.valueOf(((Byte)obj).byteValue()).toPlainString();
            } else if (obj instanceof Double) {
                String numStr = obj.toString();
                if (numStr.endsWith(".0")) {
                    DecimalFormat decimalFormatter = new DecimalFormat("0");
                    strForObj = decimalFormatter.format(obj);
                } else {
                    strForObj = BigDecimal.valueOf((Double)obj).toPlainString();
                }
            } else {
                strForObj = obj.toString();
            }
        } else {
            strForObj = obj.toString();
        }
        Trace.out((String)("Converted object " + obj.toString() + " To " + strForObj));
        return strForObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isIPv6Cluster(String node, boolean preCheck) throws VerificationException {
        boolean isIPv6OnlyCluster = true;
        Trace.out((String)"ENTRY");
        ClusterwareInfo cluInfo = new ClusterwareInfo();
        OIFCFGInfo oifCfgInfo = VerificationUtil.getOIFCFGInfo(node, preCheck);
        String oifcfgLocation = oifCfgInfo.getOIFCFGLocation();
        List OifcfgetIfList = null;
        if (!preCheck) {
            try {
                OifcfgetIfList = cluInfo.listClusterInterfaces(oifcfgLocation);
            }
            catch (InstallException ie) {
                Trace.out((String)("Install Exception : Message: " + ie.getMessage()));
                Trace.out((String)"Error while retrieving the interface information using oifcfg");
                throw new VerificationException(ie.getMessage());
            }
            Iterator itr = OifcfgetIfList.iterator();
            if (itr.hasNext()) {
                OIFCFGResult result = (OIFCFGResult)itr.next();
                Trace.out((String)("Name: " + result.getInterfaceName() + ", " + "Subnet: " + result.getSubnet() + ", " + "Type: " + result.getType() + ", " + "Interface Type: " + result.getInterfaceType()));
                if ((result.getInterfaceType().contains("PUBLIC") || result.getInterfaceType().contains("public")) && result.getType() == IPAddressUtil.IPAddrType.IPv4) {
                    isIPv6OnlyCluster = false;
                }
            }
        } else {
            String interfaceList = VerificationUtil.getVariableValue("INTERCONNECT_LIST");
            String[] interconnectLst = null;
            if (interfaceList == null) throw new VerificationException(s_msgBundle.getMessage("7613", true));
            Trace.out((String)("INTERCONNECT_LIST : " + interfaceList));
            String[] arr$ = interconnectLst = VerificationUtil.string2strArr(interfaceList);
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ < len$) {
                int end;
                String token = arr$[i$];
                int start = token.indexOf(":");
                if (start >= (end = token.lastIndexOf(":"))) throw new VerificationException(s_msgBundle.getMessage("7614", true, (Object[])new String[]{interfaceList}));
                String itr_name = token.substring(0, start);
                String subnet = token.substring(start + 1, end);
                String iftype = token.substring(end + 1);
                Trace.out((String)("Name: " + itr_name + " " + "Subnet: " + subnet + " " + "Type: " + iftype));
                if (IPAddressUtil.isIPv4AddressString((String)subnet) && 0 == iftype.compareToIgnoreCase("PUB")) {
                    isIPv6OnlyCluster = false;
                }
            }
        }
        Trace.out((String)"EXIT");
        return isIPv6OnlyCluster;
    }

    public static boolean isOTN() {
        ParamManager pm = null;
        try {
            pm = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((String)("UninitializedParamManagerException. Msg:" + e.getMessage()));
            Trace.out((Exception)e);
        }
        if (pm.getMode() == ParamManager.OperationMode.MODE_API) {
            return false;
        }
        String crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null) {
            Trace.out((String)"crsHome is null. Clusterware is not configured");
            return true;
        }
        String cvHome = System.getProperty("CV_HOME");
        if (cvHome == null) {
            cvHome = VerificationUtil.getEnv("CV_HOME");
        }
        if (cvHome == null) {
            Trace.out((String)"cvHome is null. THIS SHOULD NOT HAPPEN");
            return true;
        }
        return !crsHome.equals(cvHome);
    }

    public static void validateNewNodeRoles(String[] nodeList, NodeRoleCapability[] nodeRoleList, ParamPreReqNodeAddDel param) throws VerificationException {
        NodeManager nm = null;
        String[] confHubNodes = null;
        String[] confRimNodes = null;
        String[] confAutoNodes = null;
        String[] hubCapableNodes = null;
        int targetHubSize = -1;
        try {
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nm = nmf.getNodeManager();
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new VerificationException(nmfEx);
        }
        for (int i = 0; i < 4; ++i) {
            try {
                if (i == 0) {
                    confHubNodes = nm.getConfiguredHubNodes();
                    continue;
                }
                if (i == 1) {
                    confRimNodes = nm.getConfiguredRimNodes();
                    continue;
                }
                if (i == 2) {
                    confAutoNodes = nm.getConfiguredAutoNodes();
                    continue;
                }
                hubCapableNodes = nm.getHubCapableNodes();
                continue;
            }
            catch (NoSuchNodesException nse) {
                Trace.out((String)("NoSuchNodesException :" + nse.getMessage()));
                continue;
            }
            catch (NodeManagerException nme) {
                Trace.out((String)("NodeManagerFactoryException :" + nme.getMessage()));
                throw new VerificationException(nme);
            }
        }
        targetHubSize = nm.getTargetHubSize();
        Trace.out((String)("targetHubSize=" + targetHubSize));
        ArrayList<String> hubList = new ArrayList<String>();
        ArrayList<String> rimList = new ArrayList<String>();
        ArrayList<String> autoList = new ArrayList<String>();
        for (int i = 0; i < nodeList.length; ++i) {
            if (nodeRoleList[i] == NodeRoleCapability.HUB) {
                hubList.add(nodeList[i]);
                Trace.out((String)("Added node '" + nodeList[i] + "' to hubList"));
                continue;
            }
            if (nodeRoleList[i] == NodeRoleCapability.RIM) {
                rimList.add(nodeList[i]);
                Trace.out((String)("Added node '" + nodeList[i] + "' to rimList"));
                continue;
            }
            if (nodeRoleList[i] == NodeRoleCapability.AUTO) {
                autoList.add(nodeList[i]);
                Trace.out((String)("Added node '" + nodeList[i] + "' to autoList"));
                continue;
            }
            throw new VerificationException(s_gMsgBundle.getMessage("11400", true));
        }
        if (autoList.size() > 0 && (hubList.size() > 0 || rimList.size() > 0)) {
            throw new VerificationException(s_gMsgBundle.getMessage("11401", true));
        }
        if (autoList.size() != 0 && (confAutoNodes.length == 0 || confHubNodes.length != 0 || confRimNodes.length != 0)) {
            throw new VerificationException(s_gMsgBundle.getMessage("11402", true));
        }
        if (hubList.size() == 0 && rimList.size() != 0 && (confHubNodes == null || confHubNodes.length == 0)) {
            throw new VerificationException(s_gMsgBundle.getMessage("11403", true));
        }
        if (hubList.size() > 0 && hubCapableNodes != null && hubCapableNodes.length + hubList.size() > targetHubSize) {
            throw new VerificationException(s_gMsgBundle.getMessage("11404", true, (Object[])new String[]{Integer.toString(targetHubSize)}));
        }
        try {
            nm.addNodes(hubList.toArray(new String[0]), rimList.toArray(new String[0]), autoList.toArray(new String[0]));
        }
        catch (NodeManagerException nmEx) {
            Trace.out((String)("NodeManagerException :" + nmEx.getMessage()));
            throw new VerificationException(nmEx);
        }
    }

    public static void checkFileExistence(String[] nodeList, String file, ResultSet resultSet) {
        Trace.out((String)("nodeList=" + VerificationUtil.strArr2List(nodeList) + ";file=" + file));
        ErrorDescription errDesc = null;
        for (String node : nodeList) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Check existence of file '" + file + "'\n on node '" + node + "'"));
            }
            ClusterCmd cmd = new ClusterCmd();
            try {
                if (!cmd.fileExists(node, file)) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nCannot access file '" + file + "'" + "\n on node '" + node + "'"));
                    }
                    errDesc = new ErrorDescription("5311", new String[]{file, node}, s_msgBundle);
                    resultSet.addResult(node, 3);
                    ReportUtil.printError(errDesc.getErrorMessage());
                    resultSet.addErrorDescription(node, errDesc);
                    continue;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("File '" + file + "' exists on node '" + node + "'"));
                }
                resultSet.addResult(node, 1);
            }
            catch (ClusterException e) {
                errDesc = new ErrorDescription("5310", new String[]{file, node}, s_msgBundle);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + e.getMessage());
                ReportUtil.printError(errDesc.getErrorMessage());
                resultSet.addErrorDescription(errDesc);
                resultSet.addResult(node, 2);
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("ClusterException: \n" + (Object)((Object)e)));
            }
        }
    }

    public static void checkFileAbsence(String[] nodeList, String file, ResultSet resultSet) {
        Trace.out((String)("nodeList=" + VerificationUtil.strArr2List(nodeList) + ";file=" + file));
        ErrorDescription errDesc = null;
        for (String node : nodeList) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Check existence of file '" + file + "'\n on node '" + node + "'"));
            }
            ClusterCmd cmd = new ClusterCmd();
            try {
                if (cmd.fileExists(node, file)) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("File '" + file + "' exists on node '" + node + "'"));
                    }
                    errDesc = new ErrorDescription("11750", new String[]{file, node}, s_gMsgBundle);
                    resultSet.addResult(node, 3);
                    ReportUtil.printError(errDesc.getErrorMessage());
                    resultSet.addErrorDescription(node, errDesc);
                    continue;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nCannot access file '" + file + "'" + "\n on node '" + node + "'"));
                }
                ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11751", false, (Object[])new String[]{file}));
                resultSet.addResult(node, 1);
            }
            catch (ClusterException e) {
                errDesc = new ErrorDescription("5310", new String[]{file, node}, s_msgBundle);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + e.getMessage());
                ReportUtil.printError(errDesc.getErrorMessage());
                resultSet.addErrorDescription(errDesc);
                resultSet.addResult(node, 2);
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("ClusterException: \n" + (Object)((Object)e)));
            }
        }
    }

    public static void checkDirAbsence(String[] nodeList, String file, ResultSet resultSet) {
        Trace.out((String)("nodeList=" + VerificationUtil.strArr2List(nodeList) + ";file=" + file));
        ErrorDescription errDesc = null;
        for (String node : nodeList) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Check existence of file '" + file + "'\n on node '" + node + "'"));
            }
            ClusterCmd cmd = new ClusterCmd();
            try {
                if (cmd.dirExists(node, file)) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("File '" + file + "' exists on node '" + node + "'"));
                    }
                    errDesc = new ErrorDescription("11752", new String[]{file, node}, s_gMsgBundle);
                    resultSet.addResult(node, 3);
                    ReportUtil.printError(errDesc.getErrorMessage());
                    resultSet.addErrorDescription(node, errDesc);
                    continue;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nCannot access file '" + file + "'" + "\n on node '" + node + "'"));
                }
                ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11753", false, (Object[])new String[]{file}));
                resultSet.addResult(node, 1);
            }
            catch (ClusterException e) {
                errDesc = new ErrorDescription("11754", new String[]{file, node}, s_gMsgBundle);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + e.getMessage());
                ReportUtil.printError(errDesc.getErrorMessage());
                resultSet.addErrorDescription(errDesc);
                resultSet.addResult(node, 2);
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("ClusterException: \n" + (Object)((Object)e)));
            }
        }
    }

    public static boolean isExadataSystem() {
        return sVerificationUtil.isExadataSystem();
    }

    public static boolean isASMLibConfigured(String[] nodeList) {
        return sVerificationUtil.isASMLibConfigured(nodeList);
    }

    public static boolean isODASystem() {
        return sVerificationUtil.isODASystem();
    }

    public static boolean isPlatformLinux() {
        return VerificationUtil.getSupportedOS().equals("Linux");
    }

    public static String getShellEscapedString(String node, String string) {
        if (node == null || string == null) {
            return string;
        }
        String escapeSequence = null;
        escapeSequence = VerificationUtil.isLocalNode(node) ? "\\" : "\\\\\\";
        string = string.replaceAll("\\*", Matcher.quoteReplacement(escapeSequence + "*"));
        string = string.replaceAll("\\[", Matcher.quoteReplacement(escapeSequence + "["));
        string = string.replaceAll("\\]", Matcher.quoteReplacement(escapeSequence + "]"));
        string = string.replaceAll("\\?", Matcher.quoteReplacement(escapeSequence + "?"));
        return string;
    }

    public static VoteDiskInfo[] getVoteDiskListFromNode(String crsHome, String hubNode) throws VerificationException {
        String CRSCTL_QUERY_VOTEDISK_CMD = "crsctl query css votedisk";
        Trace.out((String)"getting vote disk information from some other node");
        String crsctlCmd = crsHome + FSEP + "bin" + FSEP + CRSCTL_QUERY_VOTEDISK_CMD;
        Command[] queryCmdArr = new Command[]{new RunGenericCommand(hubNode, crsctlCmd, null, new String[]{"NLS_LANG="})};
        ResultSet cmdExecRS = new ResultSet();
        Trace.out((String)("running " + CRSCTL_QUERY_VOTEDISK_CMD));
        new GlobalHandler().submit(queryCmdArr, 0, cmdExecRS);
        Hashtable t = cmdExecRS.getResultTable();
        Enumeration en = t.keys();
        String[] outputLines = null;
        boolean noOutput = true;
        Result result = ((VerificationCommand)queryCmdArr[0]).getResult();
        if (result.getStatus() == 1 && result.getResultInfoSet().size() > 1 && ((outputLines = (String[])result.getResultInfoSet().get(1)) != null || outputLines.length > 0)) {
            for (String line : outputLines) {
                if (!VerificationUtil.isStringGood(line)) continue;
                noOutput = false;
            }
        }
        if (noOutput || outputLines == null) {
            Trace.out((String)"command didn't produce result");
            String errMsg = s_msgBundle.getMessage("5713", true, (Object[])new String[]{CRSCTL_QUERY_VOTEDISK_CMD, hubNode});
            throw new VerificationException(errMsg);
        }
        ArrayList<VoteDiskInfo> votediskList = new ArrayList<VoteDiskInfo>(outputLines.length - 1);
        int vdisk_num = 0;
        int vdisk_status = 0;
        String vdisk_VDIN = null;
        String vdisk_path = null;
        String vdisk_group = null;
        String disk_no_string = null;
        String path_string = null;
        String grp_string = null;
        for (int i = 0; i < outputLines.length - 1; ++i) {
            Trace.out((String)("parsing line " + outputLines[i]));
            StringTokenizer st = new StringTokenizer(outputLines[i]);
            if (st.countTokens() == 0) {
                Trace.out((String)"empty line");
                continue;
            }
            if (st.countTokens() != 5) {
                Trace.out((String)"more than expected token");
                continue;
            }
            disk_no_string = st.nextToken();
            if (disk_no_string.endsWith(".")) {
                disk_no_string = disk_no_string.substring(0, disk_no_string.length() - 1);
            }
            try {
                vdisk_num = Integer.parseInt(disk_no_string);
            }
            catch (NumberFormatException e) {
                Trace.out((String)"couldn't parse the number");
                continue;
            }
            if (st.hasMoreTokens()) {
                vdisk_status = VoteDiskInfo.mapStatusToInt((String)st.nextToken());
            }
            vdisk_VDIN = st.hasMoreTokens() ? st.nextToken() : null;
            path_string = st.hasMoreTokens() ? st.nextToken() : null;
            vdisk_path = path_string != null && path_string.charAt(0) == '(' ? path_string.substring(1, path_string.length() - 1) : path_string;
            grp_string = st.hasMoreTokens() ? st.nextToken() : null;
            vdisk_group = grp_string != null && grp_string.equals("[]") ? null : grp_string.substring(1, grp_string.length() - 1);
            if (vdisk_path != null && vdisk_status != 0) {
                VoteDiskInfo votedisk = new VoteDiskInfo(vdisk_num, 0L, vdisk_status, vdisk_VDIN, vdisk_path, vdisk_group);
                Trace.out((String)votedisk.toString());
                votediskList.add(votedisk);
                continue;
            }
            Trace.out((String)"vote disk path is null or status not 0");
        }
        return votediskList.toArray(new VoteDiskInfo[0]);
    }

    public static boolean isASMLibInstallConsistent(String[] nodeList, ResultSet asmLibInstallRsltSet, Vector<String> asmLibNotInstallNodes, Vector<String> operationFailedNode) {
        return sVerificationUtil.isASMLibInstallConsistent(nodeList, asmLibInstallRsltSet, asmLibNotInstallNodes, operationFailedNode);
    }

    public static boolean isASMLibConfiguredConsistently(String[] nodeList, ResultSet asmLibconfiguredRsltSet, Vector<String> asmLibInconsistantConfigNodes, Vector<String> operationFailedNode) {
        return sVerificationUtil.isASMLibConfiguredConsistently(nodeList, asmLibconfiguredRsltSet, asmLibInconsistantConfigNodes, operationFailedNode);
    }

    public static String getDomainSocketsDir() {
        return sVerificationUtil.getDomainSocketsDir();
    }

    public static String getInitTabLoc() {
        return sVerificationUtil.getInitTabLoc();
    }

    public static String getInitdLoc() {
        return sVerificationUtil.getInitdLoc();
    }

    public static boolean isIPV6Host(String hostName) throws CVUException {
        Map addrMap = null;
        try {
            addrMap = IPAddressUtil.resolveHostname((String)hostName);
        }
        catch (IPAddressException ipAddrEx) {
            Trace.out((String)("IPAddressException exception occured while resolving hostname " + hostName + ". Msg " + ipAddrEx.getMessage()));
            throw new CVUException(ipAddrEx);
        }
        return addrMap.containsKey(IPAddressUtil.IPAddrType.IPv6) && !addrMap.containsKey(IPAddressUtil.IPAddrType.IPv4);
    }

    public static boolean isBinaryExistsInsideHome(String homeLoc, String binaryName) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (VerificationUtil.isStringGood(homeLoc)) {
            String binaryPathComplete = homeLoc + File.separator + "bin" + File.separator + nativeSys.getExeName(binaryName);
            File binaryFile = new File(binaryPathComplete);
            if (binaryFile.exists()) {
                Trace.out((String)("The binary file " + binaryName + "  was found inside home location " + homeLoc));
                VerificationLogData.log("The binary file " + binaryName + "  was found inside home location " + homeLoc);
                return true;
            }
            Trace.out((String)("The binary file " + binaryName + "  was not found inside home location " + homeLoc));
            VerificationLogData.log("The binary file " + binaryName + "  was not found inside home location " + homeLoc);
            return false;
        }
        Trace.out((String)"Supplied home location is null or an empty string");
        VerificationLogData.log("Supplied home location is null or an empty string");
        return false;
    }

    public static Hashtable<String, Boolean> getASMDiscoveryString() throws CVUException {
        if (asmDiscoveryStringHT != null) {
            Trace.out((String)"returning cached information for discovery string");
            return asmDiscoveryStringHT;
        }
        Result result = new Result(VerificationUtil.getLocalHostName());
        String asmHome = CVUHelperUtil.getASMhome(result);
        if (asmHome == null) {
            Trace.out((String)"asm home couldn't be determined by cvuhelper");
            List<VerificationError> errDescList = result.getErrors();
            String errMesg = "";
            for (VerificationError errDesc : errDescList) {
                errMesg = errMesg + errDesc.getErrorMessage() + LSEP;
            }
            throw new CVUException(errMesg);
        }
        Trace.out((String)("asm home is " + asmHome));
        String asmSid = CVUHelperUtil.getASMSid(result);
        if (asmSid == null) {
            Trace.out((String)"asm sid couldn't be determined by cvuhelper");
            List<VerificationError> errDescList = result.getErrors();
            String errMesg = "";
            for (VerificationError errDesc : errDescList) {
                errMesg = errMesg + errDesc.getErrorMessage() + LSEP;
            }
            throw new CVUException(errMesg);
        }
        File spoolFile = null;
        try {
            spoolFile = File.createTempFile("spool", ".log", new File(VerificationUtil.getCVUSubDirPath() + FSEP + "scratch"));
            spoolFile.deleteOnExit();
        }
        catch (IOException e) {
            String errMsg = s_gMsgBundle.getMessage("4564", true, (Object[])new String[]{spoolFile.getName()});
            throw new CVUException(errMsg);
        }
        ResultSet locRS = new ResultSet();
        String asmDiscStrScript = VerificationUtil.getCVUSubDirPath() + FSEP + "getASMDiskInfo.sh";
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            asmDiscStrScript = VerificationUtil.getCVUSubDirPath() + FSEP + "getASMDiskInfo.bat";
        }
        String[] args = new String[]{"-rungencmd", asmDiscStrScript, asmSid, asmHome, spoolFile.getPath(), VerificationUtil.getCVUSubDirPath()};
        Trace.out((String)("running command " + asmDiscStrScript));
        VerificationCommand[] asmDiskInfoCmdArr = new VerificationCommand[1];
        String[] env = null;
        asmDiskInfoCmdArr[0] = new VerificationCommand(m_nodeList[0], args, env);
        new GlobalHandler().submit((Command[])asmDiskInfoCmdArr, 0, locRS);
        result = asmDiskInfoCmdArr[0].getResult();
        String output = asmDiskInfoCmdArr[0].getOutput();
        int vfyCode = asmDiskInfoCmdArr[0].getVfyCode();
        if (result.getStatus() == 1) {
            if (vfyCode != 0) {
                Trace.out((String)"sqlplus execution not successful");
                String errMesg = s_gMsgBundle.getMessage("4669", true, (Object[])new String[]{VerificationUtil.getLocalHostName()});
                String errOutput = VerificationUtil.fetchTextByTags(output, "<CV_ORA_ERR>", "</CV_ORA_ERR>");
                Trace.out((String)("error output from sqlplus is " + errOutput));
                if (errOutput != null) {
                    errMesg = errMesg + errOutput.trim();
                }
                throw new CVUException(errMesg);
            }
            try {
                BufferedReader br = new BufferedReader(new FileReader(spoolFile));
                br.readLine();
                String discoveryString = br.readLine();
                if (VerificationUtil.isStringGood(discoveryString)) {
                    discoveryString = discoveryString.trim();
                }
                Trace.out((String)("discovery string is " + discoveryString));
                String isDefaultStr = br.readLine();
                if (VerificationUtil.isStringGood(isDefaultStr)) {
                    isDefaultStr = isDefaultStr.trim();
                }
                Trace.out((String)(" is default " + isDefaultStr));
                br.close();
                asmDiscoveryStringHT = new Hashtable();
                asmDiscoveryStringHT.put(discoveryString, new Boolean("TRUE".equalsIgnoreCase(isDefaultStr)));
                return asmDiscoveryStringHT;
            }
            catch (IOException e) {
                String errMesg = s_gMsgBundle.getMessage("4670", true, (Object[])new String[]{spoolFile.getName()}) + LSEP + e.getMessage();
                throw new CVUException(errMesg);
            }
        }
        String errMesg = s_gMsgBundle.getMessage("4669", true, (Object[])new String[]{VerificationUtil.getLocalHostName()});
        if (VerificationUtil.isStringGood(output)) {
            errMesg = errMesg + output;
        }
        throw new CVUException(errMesg);
    }

    static {
        s_variableValueRepos = Collections.synchronizedMap(new HashMap());
        s_conditionValueRepos = Collections.synchronizedMap(new HashMap());
        s_preReqXmlRepos = Collections.synchronizedMap(new HashMap());
        s_genericPreReqXmlFile = null;
        s_cvuLogFile = null;
        s_releaseVersionMap = Collections.synchronizedMap(new HashMap());
        s_secVariable = new HashSet<String>(Arrays.asList("DB_PWD", "ORACLE_SERVICE_USER_PASSWORD"));
        m_adminGroups = null;
        m_getAdminGroups = false;
        m_getRACGroups = false;
        m_groupExceptionReported = false;
        m_asmAdminGroup = null;
        m_asmOperGroup = null;
        m_asmDbaGroup = null;
        m_osAsmGroup = null;
        m_osOperGroup = null;
        m_osDbaGroup = null;
        m_osBackupDBAGroup = null;
        m_osDgDBAGroup = null;
        m_osKmDBAGroup = null;
        asmDiscoveryStringHT = null;
    }
}

